/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.type.MutableInteger;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.OseeSystemArtifacts;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.ViewIdUtility;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SystemSubsystemReport
extends AbstractBlam {
    private CharBackedInputStream charBak;
    private ISheetWriter excelWriter;
    private int subsysDescendantCount;
    private int subsysMarkedCount;
    private int subsysMarkedAndTracedCount;
    private int subsysMarkedAndQualifiedCount;
    private int subsysMarkedAndAllocatedToComponentCount;
    private final HashMap<String, Set<Artifact>> subsysToSubsysReqsMap = new HashMap();
    private final HashMap<String, Set<Artifact>> subsysToSysReqsMap = new HashMap();
    private final LinkedHashSet<Artifact> components = new LinkedHashSet(250);
    private List<Artifact> sysReqs;
    Set<ArtifactId> findExcludedArtifactsByView = new HashSet<ArtifactId>();
    private XCombo branchViewWidget;
    private XBranchSelectWidget viewerWidget;
    private static final int COMP_ENUM_COUNT = SubsystemCompletness.values().length;

    public String getName() {
        return "System Subsystem Report";
    }

    private void init() throws IOException {
        this.subsysDescendantCount = 0;
        this.subsysMarkedCount = 0;
        this.subsysMarkedAndTracedCount = 0;
        this.subsysMarkedAndQualifiedCount = 0;
        this.subsysMarkedAndAllocatedToComponentCount = 0;
        this.subsysToSubsysReqsMap.clear();
        this.subsysToSysReqsMap.clear();
        this.components.clear();
        this.findExcludedArtifactsByView.clear();
        this.charBak = new CharBackedInputStream();
        this.excelWriter = new ExcelXmlWriter(this.charBak.getWriter());
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Generating Reports", 100);
        BranchId branch = variableMap.getBranch("Branch");
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        this.init();
        this.findExcludedArtifactsByView = ViewIdUtility.findExcludedArtifactsByView((ArtifactId)this.viewId, (BranchId)branch);
        monitor.subTask("Aquiring System Components");
        ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.Component, (BranchId)branch);
        monitor.subTask("Aquiring System Requirements");
        ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SystemRequirementMsWord, (BranchId)branch);
        monitor.subTask("Aquiring Subsystem Requirements");
        ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SubsystemRequirementMsWord, (BranchId)branch);
        Artifact root = OseeSystemArtifacts.getDefaultHierarchyRootArtifact((BranchId)branch);
        Artifact subsysTopFolder = root.getChild(CoreArtifactTokens.SubSystemRequirementsFolder.getName());
        this.sysReqs = root.getChild(CoreArtifactTokens.SystemRequirementsFolder.getName()).getDescendants();
        if (this.sysReqs != null && !this.sysReqs.isEmpty()) {
            ViewIdUtility.removeExcludedArtifacts(this.sysReqs.iterator(), this.findExcludedArtifactsByView);
        }
        monitor.subTask("Generating Metrics");
        this.generateMetrics(this.getProductComponent(root), subsysTopFolder);
        monitor.subTask("Generating Per Subsystem Tables");
        this.generatePerSubsystemTables();
        this.excelWriter.endWorkbook();
        IFile iFile = OseeData.getIFile((String)("System_Subsystem_Report_" + Lib.getDateTimeString() + ".xml"));
        AIFile.writeToFile((IFile)iFile, (InputStream)this.charBak);
        Program.launch((String)iFile.getLocation().toOSString());
    }

    private void storeInHierarchyOrderBySubsystem(String subSysName, List<Artifact> sysReqByComp) {
        LinkedHashSet<Artifact> orderedSysReqs = new LinkedHashSet<Artifact>(sysReqByComp.size());
        for (Artifact sysReq : this.sysReqs) {
            if (!sysReqByComp.contains(sysReq)) continue;
            orderedSysReqs.add(sysReq);
        }
        this.subsysToSysReqsMap.put(subSysName, orderedSysReqs);
    }

    private void generateMetrics(Artifact productComponent, Artifact subsysTopFolder) throws IOException {
        this.excelWriter.startSheet("Metrics", 8);
        Object[] row = new String[]{"Subsystem Name", "# of allocated Sys Req", "# of Subsys Descendants", "# of Subsys Req Marked", "# of Subsys Req Traceable to Sys Req", "# of Subsys Req with Qual Method Defined", "# of Subsys Req allocated to HW/SW Components", "Req GUID not allocated"};
        this.excelWriter.writeRow(row);
        CountingMap allocatedSysReqCounter = new CountingMap(this.sysReqs.size());
        List children = subsysTopFolder.getChildren();
        if (!children.isEmpty()) {
            ViewIdUtility.removeExcludedArtifacts(children.iterator(), this.findExcludedArtifactsByView);
        }
        for (Artifact subsysFolder : children) {
            this.resetCounters();
            String subSysName = subsysFolder.getName();
            row[0] = subSysName;
            Artifact component = productComponent.getChild(subSysName);
            List sysReqByComp = component.getRelatedArtifacts(CoreRelationTypes.Allocation_Requirement);
            if (!sysReqByComp.isEmpty()) {
                ViewIdUtility.removeExcludedArtifacts(sysReqByComp.iterator(), this.findExcludedArtifactsByView);
            }
            this.storeInHierarchyOrderBySubsystem(subSysName, sysReqByComp);
            allocatedSysReqCounter.put((Collection)sysReqByComp);
            LinkedHashSet<String> missingAllocationGuids = new LinkedHashSet<String>();
            this.recurseWholeSubsystem(subSysName, subsysFolder, missingAllocationGuids);
            row[1] = String.valueOf(sysReqByComp.size());
            row[2] = String.valueOf(this.subsysDescendantCount);
            row[3] = String.valueOf(this.subsysMarkedCount);
            row[4] = String.valueOf(this.subsysMarkedAndTracedCount);
            row[5] = String.valueOf(this.subsysMarkedAndQualifiedCount);
            row[6] = String.valueOf(this.subsysMarkedAndAllocatedToComponentCount);
            row[7] = Collections.toString((String)", ", missingAllocationGuids);
            this.excelWriter.writeRow(row);
        }
        int exactlyOnceCount = 0;
        int moreThanOnceCount = 0;
        for (Map.Entry entry : allocatedSysReqCounter.getCounts()) {
            int count = ((MutableInteger)entry.getValue()).getValue();
            if (count == 1) {
                ++exactlyOnceCount;
                continue;
            }
            ++moreThanOnceCount;
        }
        this.excelWriter.writeRow(new Object[0]);
        this.excelWriter.writeRow(new Object[0]);
        this.excelWriter.writeRow(new Object[]{"Total # of system requirements", String.valueOf(this.sysReqs.size())});
        this.excelWriter.writeRow(new Object[]{"# of system requirements alloacted exactly once", String.valueOf(exactlyOnceCount)});
        this.excelWriter.writeRow(new Object[]{"# of system requirements alloacted more than once", String.valueOf(moreThanOnceCount)});
        this.excelWriter.writeRow(new Object[]{"# of system requirements not alloacted", String.valueOf(this.sysReqs.size() - moreThanOnceCount - exactlyOnceCount)});
        this.excelWriter.endSheet();
    }

    private void generatePerSubsystemTables() throws IOException {
        for (Map.Entry<String, Set<Artifact>> entry : this.subsysToSubsysReqsMap.entrySet()) {
            String subSysName = entry.getKey();
            Set<Artifact> subsysReqs = entry.getValue();
            this.generateSubsystemRaw(subSysName, subsysReqs);
            this.generateSubsystemComponentAllocation(subSysName, subsysReqs);
            this.generateComponentAllocation(subSysName, subsysReqs);
            this.generateSystemToSubsystemTrace(subSysName);
            this.generateSubsystemToSystemTrace(subSysName);
        }
    }

    private void generateSubsystemRaw(String subSysName, Set<Artifact> subsysReqs) throws IOException {
        this.excelWriter.startSheet(this.getShortSheetName(subSysName, "Comp"), 6);
        this.excelWriter.writeRow(new Object[]{"Detailed Subsystem Requirement Completeness Report for " + subSysName});
        this.excelWriter.writeRow(new Object[]{"Paragraph #", "Paragraph Title", CoreAttributeTypes.Subsystem.getName(), CoreAttributeTypes.QualificationMethod.getName(), "Trace Count", "Allocation Count"});
        Object[] row = new String[COMP_ENUM_COUNT];
        for (Artifact artifact : subsysReqs) {
            row[SubsystemCompletness.paragraphNumber.ordinal()] = (String)artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
            row[SubsystemCompletness.name.ordinal()] = artifact.getName();
            row[SubsystemCompletness.subSys.ordinal()] = (String)artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"");
            row[SubsystemCompletness.qualMethod.ordinal()] = artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SubsystemRequirementMsWord}) ? artifact.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.QualificationMethod) : "N/A: " + artifact.getArtifactTypeName();
            int higherTraceCount = artifact.getRelatedArtifactsCount(CoreRelationTypes.RequirementTrace_HigherLevelRequirement);
            row[SubsystemCompletness.highLevelTrace.ordinal()] = String.valueOf(higherTraceCount);
            int allocationCount = artifact.getRelatedArtifactsCount(CoreRelationTypes.Allocation_Component);
            row[SubsystemCompletness.allocated.ordinal()] = String.valueOf(allocationCount);
            this.excelWriter.writeRow(row);
        }
        this.excelWriter.endSheet();
    }

    private void generateSubsystemComponentAllocation(String subSysName, Set<Artifact> subsysReqs) throws IOException {
        this.excelWriter.startSheet(this.getShortSheetName(subSysName, "5.1"), 3);
        this.excelWriter.writeRow(new Object[]{"Subsystem SSDD section 5.1"});
        this.excelWriter.writeRow(new Object[]{"Paragraph #", "Paragraph Title", "Allocated Components"});
        Object[] row = new String[3];
        for (Artifact artifact : subsysReqs) {
            row[0] = (String)artifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
            row[1] = artifact.getName();
            if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SubsystemRequirementMsWord})) {
                boolean isRelated = false;
                List relatedArtifacts = artifact.getRelatedArtifacts(CoreRelationTypes.Allocation_Component);
                if (!relatedArtifacts.isEmpty()) {
                    ViewIdUtility.removeExcludedArtifacts(relatedArtifacts.iterator(), this.findExcludedArtifactsByView);
                    isRelated = true;
                }
                for (Artifact component : relatedArtifacts) {
                    this.components.add(component);
                    row[2] = component.getName();
                    this.excelWriter.writeRow(row);
                }
                if (row[0] == null || isRelated) continue;
                row[2] = null;
                this.excelWriter.writeRow(row);
                continue;
            }
            row[2] = "N/A: " + artifact.getArtifactTypeName();
            this.excelWriter.writeRow(row);
        }
        this.excelWriter.endSheet();
    }

    private void generateComponentAllocation(String subSysName, Set<Artifact> subsysReqs) throws IOException {
        this.excelWriter.startSheet(this.getShortSheetName(subSysName, "5.2"), 3);
        this.excelWriter.writeRow(new Object[]{"Subsystem SSDD section 5.2"});
        Object[] row = new String[3];
        for (Artifact component : this.components) {
            this.excelWriter.writeRow(new Object[0]);
            this.excelWriter.writeRow(new Object[0]);
            this.excelWriter.writeRow(new Object[]{String.valueOf(subSysName) + " Subsystem Requirements allocated to the " + component.getName()});
            this.excelWriter.writeRow(new Object[]{"PIDS Paragraph #", "PIDS Paragraph Title", "Notes <rationale>"});
            List relatedArtifacts = component.getRelatedArtifacts(CoreRelationTypes.Allocation_Requirement);
            if (!relatedArtifacts.isEmpty()) {
                ViewIdUtility.removeExcludedArtifacts(relatedArtifacts.iterator(), this.findExcludedArtifactsByView);
            }
            for (Artifact subsysReq : relatedArtifacts) {
                if (!subsysReqs.contains(subsysReq)) continue;
                row[0] = (String)subsysReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
                row[1] = subsysReq.getName();
                String rationale = component.getRelationRationale(subsysReq, CoreRelationTypes.Allocation_Requirement);
                row[2] = rationale.equals("") ? null : rationale;
                this.excelWriter.writeRow(row);
            }
        }
        this.components.clear();
        this.excelWriter.endSheet();
    }

    private void recurseWholeSubsystem(String subSysName, Artifact subsysFolder, Set<String> missingAllocationGuids) {
        LinkedHashSet<Artifact> subsysReqs = new LinkedHashSet<Artifact>();
        this.subsysToSubsysReqsMap.put(subSysName, subsysReqs);
        this.countDescendants(subSysName, subsysReqs, subsysFolder, missingAllocationGuids);
    }

    private void resetCounters() {
        this.subsysDescendantCount = 0;
        this.subsysMarkedCount = 0;
        this.subsysMarkedAndTracedCount = 0;
        this.subsysMarkedAndQualifiedCount = 0;
        this.subsysMarkedAndAllocatedToComponentCount = 0;
    }

    private void countDescendants(String subSysName, Set<Artifact> subsysReqs, Artifact artifact, Set<String> missingAllocationGuids) {
        List children = artifact.getChildren();
        if (!children.isEmpty()) {
            ViewIdUtility.removeExcludedArtifacts(children.iterator(), this.findExcludedArtifactsByView);
        }
        for (Artifact child : children) {
            if (child.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SubsystemRequirementMsWord})) {
                ++this.subsysDescendantCount;
                String selectedSubSystem = (String)child.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"");
                if (selectedSubSystem.equals(subSysName)) {
                    int allocationCount;
                    int higherTraceCount;
                    ++this.subsysMarkedCount;
                    String qualMethod = child.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.QualificationMethod);
                    if (!qualMethod.equals("Unspecified")) {
                        ++this.subsysMarkedAndQualifiedCount;
                    }
                    if ((higherTraceCount = child.getRelatedArtifactsCount(CoreRelationTypes.RequirementTrace_HigherLevelRequirement)) > 0) {
                        ++this.subsysMarkedAndTracedCount;
                    }
                    if ((allocationCount = child.getRelatedArtifactsCount(CoreRelationTypes.Allocation_Component)) > 0) {
                        ++this.subsysMarkedAndAllocatedToComponentCount;
                    } else {
                        missingAllocationGuids.add(child.getGuid());
                    }
                }
                subsysReqs.add(child);
            }
            this.countDescendants(subSysName, subsysReqs, child, missingAllocationGuids);
        }
    }

    private void generateSystemToSubsystemTrace(String subSysName) throws IOException {
        this.excelWriter.startSheet(this.getShortSheetName(subSysName, "System Trace"), 4);
        this.excelWriter.writeRow(new Object[]{subSysName, "System To Subsystem Trace"});
        this.excelWriter.writeRow(new Object[]{CoreArtifactTypes.SystemRequirementMsWord.getName(), null, "Traceable Subsystem Requirement", null});
        this.excelWriter.writeRow(new Object[]{"Paragraph #", "Paragraph Title", "Paragraph #", "Paragraph Title"});
        Object[] row = new String[4];
        Set<Artifact> orderedSysReqs = this.subsysToSysReqsMap.get(subSysName);
        Set<Artifact> subsysReqs = this.subsysToSubsysReqsMap.get(subSysName);
        for (Artifact sysReq : orderedSysReqs) {
            row[0] = (String)sysReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
            row[1] = sysReq.getName();
            boolean isRelated = false;
            List relatedArtifacts = sysReq.getRelatedArtifacts(CoreRelationTypes.RequirementTrace_LowerLevelRequirement);
            if (!relatedArtifacts.isEmpty()) {
                ViewIdUtility.removeExcludedArtifacts(relatedArtifacts.iterator(), this.findExcludedArtifactsByView);
                isRelated = true;
            }
            for (Artifact subSysReq : relatedArtifacts) {
                if (!subsysReqs.contains(subSysReq)) continue;
                row[2] = (String)subSysReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
                row[3] = subSysReq.getName();
                this.excelWriter.writeRow(row);
            }
            if (row[0] == null || isRelated) continue;
            row[3] = null;
            row[2] = null;
            this.excelWriter.writeRow(row);
        }
        this.excelWriter.endSheet();
    }

    private String getShortSheetName(String subSysName, String sufix) {
        String shortenSubSysName = subSysName.contains(" ") ? WordUtils.initials((String)subSysName) : subSysName;
        return String.valueOf(shortenSubSysName) + " " + sufix;
    }

    private void generateSubsystemToSystemTrace(String subSysName) throws IOException {
        this.excelWriter.startSheet(this.getShortSheetName(subSysName, "Subsystem Trace"), 5);
        Set<Artifact> subsysReqs = this.subsysToSubsysReqsMap.get(subSysName);
        this.excelWriter.writeRow(new Object[]{subSysName, "Subsystem To System Trace"});
        this.excelWriter.writeRow(new Object[]{CoreArtifactTypes.SubsystemRequirementMsWord.getName(), null, null, "Traceable System Requirement", null});
        this.excelWriter.writeRow(new Object[]{"Paragraph #", "Paragraph Title", CoreAttributeTypes.QualificationMethod.getName(), "Paragraph #", "Paragraph Title"});
        Object[] row = new String[5];
        for (Artifact subsysReq : subsysReqs) {
            row[0] = (String)subsysReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
            row[1] = subsysReq.getName();
            row[2] = subsysReq.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SubsystemRequirementMsWord}) ? subsysReq.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.QualificationMethod) : "N/A: " + subsysReq.getArtifactTypeName();
            boolean isRelated = false;
            List relatedArtifacts = subsysReq.getRelatedArtifacts(CoreRelationTypes.RequirementTrace_HigherLevelRequirement);
            if (!relatedArtifacts.isEmpty()) {
                ViewIdUtility.removeExcludedArtifacts(relatedArtifacts.iterator(), this.findExcludedArtifactsByView);
                isRelated = true;
            }
            for (Artifact subSysReq : relatedArtifacts) {
                row[3] = (String)subSysReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
                row[4] = subSysReq.getName();
                this.excelWriter.writeRow(row);
            }
            if (row[0] == null || isRelated) continue;
            row[4] = null;
            row[3] = null;
            this.excelWriter.writeRow(row);
        }
        this.excelWriter.endSheet();
    }

    private Artifact getProductComponent(Artifact root) {
        for (Artifact artifact : root.getChildren()) {
            if (!artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Component})) continue;
            return artifact;
        }
        throw new OseeStateException("Did not find a child of the hierarchy root that was of type ", new Object[]{CoreArtifactTypes.Component});
    }

    public String getDescriptionUsage() {
        return "Generates a spreadsheet of traceability and allocation for sys <-> subsys.";
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals("Branch")) {
            this.viewerWidget = (XBranchSelectWidget)xWidget;
            this.viewerWidget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (SystemSubsystemReport.this.branchViewWidget != null) {
                        SystemSubsystemReport.this.branchViewWidget.setEditable(true);
                        BranchToken branch = SystemSubsystemReport.this.viewerWidget.getSelection();
                        if (branch != null && branch.isValid()) {
                            SystemSubsystemReport.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            SystemSubsystemReport.this.branchViewWidget.setDataStrings(SystemSubsystemReport.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.REPORTS);
    }

    private static enum SubsystemCompletness {
        paragraphNumber,
        name,
        subSys,
        qualMethod,
        highLevelTrace,
        allocated;

    }
}

