/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class FixAttributeOperation
extends AbstractOperation {
    private final BranchToken branch;
    private final boolean commitChangesBool;
    private final Display display;

    public FixAttributeOperation(OperationLogger logger, Display display, BranchToken branch, boolean commitChangesBool) {
        super("FixAttributes", "org.eclipse.nebula.widgets.xviewer", logger);
        this.branch = branch;
        this.commitChangesBool = commitChangesBool;
        this.display = display;
    }

    private void checkPreConditions() {
        Conditions.checkNotNull((Object)this.branch, (String)"branch");
        Conditions.checkExpressionFailOnTrue((!BranchManager.getType((BranchId)this.branch).isWorkingBranch() ? 1 : 0) != 0, (String)"Invalid branch selected [%s]. Only working branches are allowed.", (Object[])new Object[]{this.branch});
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        this.checkPreConditions();
        monitor.subTask("Aquiring Artifacts");
        HashCollectionSet<Artifact, AttributeTypeToken> artifactAttributeMap = this.getArtifactsWithDuplicates(monitor);
        SkynetTransaction transaction = null;
        if (this.commitChangesBool) {
            transaction = TransactionManager.createTransaction((BranchId)this.branch, (String)"Fixing Duplicate Enumerated Types");
        }
        ArrayList<String[]> rowData = new ArrayList<String[]>();
        for (Map.Entry entry : artifactAttributeMap.entrySet()) {
            Artifact artifact = (Artifact)entry.getKey();
            for (AttributeTypeToken attributeType : (Set)entry.getValue()) {
                List attributeValues = artifact.getAttributeValues((AttributeTypeId)attributeType);
                if (!this.hasDuplicates(attributeValues)) continue;
                this.logf("duplicates found art[%s] attrType[%s] values[%s]", new Object[]{artifact, attributeType, attributeValues});
                artifact.setAttributeFromValues((AttributeTypeId)attributeType, (Collection)attributeValues);
                List attributeValuesFixed = artifact.getAttributeValues((AttributeTypeId)attributeType);
                if (transaction != null) {
                    transaction.addArtifact(artifact);
                }
                rowData.add(new String[]{this.branch.getName(), artifact.getIdString(), artifact.getName(), attributeType.getName(), Collections.toString((String)", ", (Iterable)attributeValues), Collections.toString((String)", ", (Iterable)attributeValuesFixed)});
            }
        }
        if (rowData.isEmpty()) {
            rowData.add(new String[]{"-- no duplicates found --", "-- no duplicates found --", "-- no duplicates found --", "-- no duplicates found --", "-- no duplicates found --", "-- no duplicates found --"});
        }
        this.display.displayReport("Fix Duplicate Report", rowData);
        if (transaction != null) {
            transaction.execute();
        } else {
            for (Artifact artifact : artifactAttributeMap.keySet()) {
                ArtifactCache.deCache((Artifact)artifact);
            }
        }
    }

    private HashCollectionSet<Artifact, AttributeTypeToken> getArtifactsWithDuplicates(IProgressMonitor monitor) {
        HashCollectionSet artifactAttributeMap = new HashCollectionSet(HashSet::new);
        List artifacts = ArtifactQuery.getArtifactListFromBranch((BranchId)this.branch, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED);
        FixAttributeOperation.checkForCancelledStatus((IProgressMonitor)monitor);
        monitor.subTask("Mapping Enumerated Attributes");
        for (Artifact artifact : artifacts) {
            List attributes = artifact.getAttributes();
            for (Attribute attribute : attributes) {
                FixAttributeOperation.checkForCancelledStatus((IProgressMonitor)monitor);
                AttributeTypeToken attributeType = attribute.getAttributeType();
                if (!attributeType.isEnumerated()) continue;
                artifactAttributeMap.put((Object)artifact, (Object)attributeType);
            }
        }
        return artifactAttributeMap;
    }

    private boolean hasDuplicates(List<Object> attributeValues) {
        boolean result = false;
        HashSet<Object> set = new HashSet<Object>();
        for (Object object : attributeValues) {
            if (set.add(object)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static interface Display {
        public void displayReport(String var1, List<String[]> var2);
    }
}

