/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.IPDEColorConstants;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ColorManager
implements IColorManager,
IPDEColorConstants {
    private static ColorManager fColorManager;
    private Map<String, Color> fColorTable = new HashMap<String, Color>(5);
    private static int counter;

    static {
        counter = 0;
    }

    public ColorManager() {
        this.initialize();
    }

    public static IColorManager getDefault() {
        if (fColorManager == null) {
            fColorManager = new ColorManager();
        }
        ++counter;
        return fColorManager;
    }

    public static void initializeDefaults(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.default", (RGB)DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.instr", (RGB)PROC_INSTR);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.string", (RGB)STRING);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.externalized_string", (RGB)EXTERNALIZED_STRING);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.tag", (RGB)TAG);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.xml_comment", (RGB)XML_COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_key", (RGB)HEADER_KEY);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_osgi", (RGB)HEADER_OSGI);
        store.setDefault("editor.color.header_osgi_bold", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_value", (RGB)HEADER_VALUE);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_attributes", (RGB)HEADER_ATTRIBUTES);
        store.setDefault("editor.color.header_attributes_italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_assignment", (RGB)HEADER_ASSIGNMENT);
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        try {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = () -> {
                if (!display.isDisposed() && display.getHighContrast()) {
                    PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.default", (RGB)DEFAULT_HIGH_CONTRAST);
                    PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_value", (RGB)HEADER_VALUE_HIGH_CONTRAST);
                    PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.header_attributes", (RGB)HEADER_ASSIGNMENT_HIGH_CONTRAST);
                }
            };
            if (display == Display.getCurrent()) {
                runnable.run();
            } else {
                display.asyncExec(runnable);
            }
        }
        catch (IllegalStateException | SWTException throwable) {}
    }

    private void initialize() {
        IPreferenceStore pstore = PDEPlugin.getDefault().getPreferenceStore();
        this.putColor(pstore, "editor.color.default");
        this.putColor(pstore, "editor.color.instr");
        this.putColor(pstore, "editor.color.string");
        this.putColor(pstore, "editor.color.externalized_string");
        this.putColor(pstore, "editor.color.tag");
        this.putColor(pstore, "editor.color.xml_comment");
        this.putColor(pstore, "editor.color.header_key");
        this.putColor(pstore, "editor.color.header_osgi");
        this.putColor(pstore, "editor.color.header_value");
        this.putColor(pstore, "editor.color.header_attributes");
        this.putColor(pstore, "editor.color.header_assignment");
        pstore = PreferenceConstants.getPreferenceStore();
        String[] stringArray = IColorManager.PROPERTIES_COLORS;
        int n = IColorManager.PROPERTIES_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            String color = stringArray[n2];
            this.putColor(pstore, color);
            ++n2;
        }
    }

    public void disposeColors(boolean resetSingleton) {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        if (resetSingleton) {
            fColorManager = null;
        }
    }

    @Override
    public void dispose() {
        if (--counter == 0) {
            this.disposeColors(true);
        }
    }

    private void putColor(IPreferenceStore pstore, String property) {
        this.putColor(property, PreferenceConverter.getColor((IPreferenceStore)pstore, (String)property));
    }

    private void putColor(String property, RGB setting) {
        Color oldColor = this.fColorTable.get(property);
        if (oldColor != null) {
            if (oldColor.getRGB().equals((Object)setting)) {
                return;
            }
            oldColor.dispose();
        }
        this.fColorTable.put(property, new Color((Device)Display.getCurrent(), setting));
    }

    @Override
    public Color getColor(String key) {
        Color color = this.fColorTable.get(key);
        if (color == null) {
            color = Display.getCurrent().getSystemColor(24);
        }
        return color;
    }

    @Override
    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Object color = event.getNewValue();
        if (color instanceof RGB) {
            this.putColor(event.getProperty(), (RGB)color);
        } else {
            this.putColor(event.getProperty(), StringConverter.asRGB((String)color.toString()));
        }
    }
}

