/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt.hex;

import java.util.Arrays;
import org.eclipse.osee.framework.ui.swt.hex.HexTableContentProvider;
import org.eclipse.osee.framework.ui.swt.hex.HexTableRow;
import org.eclipse.osee.framework.ui.swt.hex.IHexTblHighlighter;
import org.eclipse.swt.graphics.Color;

class Highlighter
implements IHexTblHighlighter {
    private int index;
    private int length;
    private Color color;
    private final HexTableContentProvider provider;
    private boolean displayAsAscii = false;

    Highlighter(HexTableContentProvider provider, int index, int length, Color color) {
        this.index = index;
        this.length = length;
        this.color = color;
        this.provider = provider;
    }

    @Override
    public void highlight() {
        this.highlight(this.color, this.displayAsAscii);
    }

    private void highlight(Color highlightColor, boolean ascii) {
        int row;
        int endRow = row = this.index / this.provider.getBytesPerRow();
        int col = this.index - row * this.provider.getBytesPerRow();
        HexTableRow[] elements = this.provider.getElements();
        int i = 0;
        while (i < this.length) {
            HexTableRow e = elements[endRow];
            e.setBackgroundColor(col, highlightColor);
            e.setDisplayAsAscii(col, ascii);
            if (++col >= e.length) {
                ++endRow;
                col = 0;
            }
            ++i;
        }
        this.provider.getViewer().update((Object[])Arrays.copyOfRange(elements, row, endRow + 1), null);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.highlight();
    }

    @Override
    public void setRange(int start, int length) {
        this.index = start;
        this.length = length;
        this.highlight(this.provider.getViewer().getTable().getBackground(), false);
        this.highlight();
    }

    @Override
    public void setDisplayAsAscii(boolean displayAsAscii) {
        this.displayAsAscii = displayAsAscii;
    }
}

