/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.swt.events.KeyEvent;

public class Search {
    private final String[] items;
    private String searchString = "";
    private int firstIndex;
    private int lastIndex;
    private boolean dirty;

    public Search(String[] items) {
        this.items = items;
        this.firstIndex = -1;
        this.lastIndex = -1;
        this.dirty = true;
    }

    public String[] getItems() {
        if (this.lastIndex == -1 || this.firstIndex == -1) {
            return this.items;
        }
        int range = this.lastIndex - this.firstIndex;
        String[] temp = new String[range];
        System.arraycopy(this.items, this.firstIndex, temp, 0, range);
        return temp;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void progressiveSearch(KeyEvent e) {
        int first = -1;
        int last = -1;
        if (!Character.isISOControl(e.character)) {
            this.searchString = new String(String.valueOf(this.searchString) + e.character);
        } else {
            if (e.character != '\b') return;
            if (this.searchString.length() > 1) {
                this.searchString = new String(this.searchString.substring(0, this.searchString.length() - 1));
            } else {
                if (this.searchString.length() != 1) return;
                this.reset();
            }
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].length() >= this.searchString.length() && this.searchString.equalsIgnoreCase(this.items[i].substring(0, this.searchString.length()))) {
                first = i;
                break;
            }
            ++i;
        }
        if (first != -1) {
            i = first;
            while (i < this.items.length) {
                if (this.items[i].length() >= this.searchString.length() && !this.searchString.equalsIgnoreCase(this.items[i].substring(0, this.searchString.length()))) {
                    last = i;
                    break;
                }
                ++i;
            }
            if (last == -1) {
                this.lastIndex = this.items.length;
            }
        } else {
            this.searchString = new String(this.searchString.substring(0, this.searchString.length() - 1));
        }
        if (first == -1 || last == -1) return;
        this.firstIndex = first;
        this.lastIndex = last;
        this.dirty = true;
    }

    public void reset() {
        this.firstIndex = 0;
        this.lastIndex = this.items.length;
        this.searchString = new String("");
        this.dirty = true;
    }

    public int getLength() {
        return this.searchString.length();
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean value) {
        this.dirty = value;
    }
}

