/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsLayoutItem;
import org.eclipse.osee.ats.api.workdef.IAtsPeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.StateColor;
import org.eclipse.osee.ats.api.workdef.StateOption;
import org.eclipse.osee.ats.api.workdef.StateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.AbstractWorkDefItem;
import org.eclipse.osee.ats.api.workdef.model.DecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.model.PeerReviewDefinition;
import org.eclipse.osee.ats.api.workdef.model.RuleManager;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class StateDefinition
extends AbstractWorkDefItem
implements IAtsStateDefinition {
    private StateType StateType;
    private int ordinal = 0;
    private List<IAtsLayoutItem> stateItems = new ArrayList<IAtsLayoutItem>(5);
    private final RuleManager ruleMgr = new RuleManager();
    private final List<IAtsStateDefinition> toStates = new ArrayList<IAtsStateDefinition>(5);
    private final List<IAtsDecisionReviewDefinition> decisionReviews = new ArrayList<IAtsDecisionReviewDefinition>();
    private final List<IAtsPeerReviewDefinition> peerReviews = new ArrayList<IAtsPeerReviewDefinition>();
    private IAtsWorkDefinition workDefinition;
    private int stateWeight = 0;
    private Integer recommendedPercentComplete = null;
    private StateColor color = null;
    private final List<IAtsTransitionHook> transitionListeners = new ArrayList<IAtsTransitionHook>();
    private List<StateOption> stateOptions = new ArrayList<StateOption>();

    public StateDefinition(String name) {
        super(Long.valueOf(name.hashCode()), name);
    }

    @Override
    public List<IAtsLayoutItem> getLayoutItems() {
        return this.stateItems;
    }

    @Override
    public StateType getStateType() {
        return this.StateType;
    }

    @Override
    public void setLayoutItems(List<IAtsLayoutItem> layoutToSet) {
        this.stateItems = layoutToSet;
    }

    public void setStateType(StateType StateType2) {
        this.StateType = StateType2;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public List<IAtsStateDefinition> getToStates() {
        if (this.toStates.size() == 1 && this.toStates.iterator().next() == StateToken.ANY) {
            return this.workDefinition.getStates();
        }
        return this.toStates;
    }

    @Override
    public IAtsWorkDefinition getWorkDefinition() {
        return this.workDefinition;
    }

    @Override
    public void setWorkDefinition(IAtsWorkDefinition workDefinition) {
        this.workDefinition = workDefinition;
    }

    @Override
    public String toString() {
        return String.format("%s  - (%s)", new Object[]{this.getName(), this.getStateType()});
    }

    @Override
    public String getFullName() {
        if (this.workDefinition != null) {
            return String.valueOf(this.workDefinition.getName()) + "." + this.getName();
        }
        return this.getName();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            IAtsStateDefinition other = (IAtsStateDefinition)obj;
            if (Strings.isValid((String)this.getName()) && Strings.isValid((String)other.getName()) && this.getName().equals(other.getName())) {
                equals = true;
            }
        }
        return equals;
    }

    @Override
    public List<IAtsDecisionReviewDefinition> getDecisionReviews() {
        return this.decisionReviews;
    }

    @Override
    public List<IAtsPeerReviewDefinition> getPeerReviews() {
        return this.peerReviews;
    }

    @Override
    public int getStateWeight() {
        return this.stateWeight;
    }

    public void setStateWeight(int percentWeight) {
        this.stateWeight = percentWeight;
    }

    public void setRecommendedPercentComplete(int recommendedPercentComplete) {
        this.recommendedPercentComplete = recommendedPercentComplete;
    }

    @Override
    public Integer getRecommendedPercentComplete() {
        return this.recommendedPercentComplete;
    }

    public void setColor(StateColor stateColor) {
        this.color = stateColor;
    }

    @Override
    public StateColor getColor() {
        return this.color;
    }

    public void removeRule(String rule) {
        this.ruleMgr.removeRule(rule);
    }

    @Override
    public List<String> getRules() {
        return this.ruleMgr.getRules();
    }

    public void addRule(String rule) {
        this.ruleMgr.addRule(rule);
    }

    @Override
    public boolean hasRule(String rule) {
        return this.ruleMgr.hasRule(rule);
    }

    public void addDecisionReview(DecisionReviewDefinition reviewDefinition) {
        this.decisionReviews.add(reviewDefinition);
    }

    public void addPeerReview(PeerReviewDefinition reviewDefinition) {
        this.peerReviews.add(reviewDefinition);
    }

    @Override
    public void addTransitionListener(IAtsTransitionHook transitionListener) {
        this.transitionListeners.add(transitionListener);
    }

    @Override
    public List<IAtsTransitionHook> getTransitionListeners() {
        return this.transitionListeners;
    }

    @Override
    public List<StateOption> getStateOptions() {
        return this.stateOptions;
    }

    @Override
    public void setStateOptions(List<StateOption> stateOptions) {
        this.stateOptions = stateOptions;
    }
}

