/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.review;

import java.text.NumberFormat;
import org.eclipse.osee.ats.api.review.ReviewRole;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class UserRole {
    private ReviewRole role;
    private String userId;
    private Double hoursSpent = null;
    private String guid = GUID.create();
    private Boolean completed = false;

    public UserRole(ReviewRole role, AtsUser user) {
        this(role, user.getUserId());
    }

    public UserRole(ReviewRole role, String userId) {
        this(role, userId, (Double)0.0, (Boolean)false);
    }

    public UserRole(ReviewRole role, AtsUser user, Double hoursSpent, Boolean completed) {
        this(role, user.getUserId(), hoursSpent, completed);
    }

    public UserRole(ReviewRole role, String userId, Double hoursSpent, Boolean completed) {
        this.role = role;
        this.userId = userId;
        this.hoursSpent = hoursSpent;
        this.completed = completed;
    }

    public UserRole(String xml, IAtsWorkDefinition workDefinition) {
        this.fromXml(xml, workDefinition);
    }

    public void update(UserRole dItem, IAtsWorkDefinition workDefinition) {
        this.fromXml(dItem.toXml(), workDefinition);
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append(AXml.addTagData((String)"role", (String)this.role.getName()));
        sb.append(AXml.addTagData((String)"userId", (String)this.userId));
        sb.append(AXml.addTagData((String)"hoursSpent", (String)(this.hoursSpent == null ? "" : String.valueOf(this.hoursSpent))));
        sb.append(AXml.addTagData((String)"completed", (String)String.valueOf(this.completed)));
        sb.append(AXml.addTagData((String)"guid", (String)this.guid));
        return sb.toString();
    }

    private void fromXml(String xml, IAtsWorkDefinition workDefinition) {
        try {
            this.role = workDefinition.fromName(AXml.getTagData((String)xml, (String)"role"));
            this.userId = AXml.getTagData((String)xml, (String)"userId");
            String hoursSpent = AXml.getTagData((String)xml, (String)"hoursSpent");
            this.hoursSpent = Strings.isValid((String)hoursSpent) ? Double.valueOf(NumberFormat.getInstance().parse(hoursSpent).doubleValue()) : null;
            String completedStr = AXml.getTagData((String)xml, (String)"completed");
            this.completed = Strings.isValid((String)completedStr) ? Boolean.valueOf(completedStr.equals("true")) : Boolean.valueOf(false);
            this.guid = AXml.getTagData((String)xml, (String)"guid");
        }
        catch (Exception ex) {
            throw new OseeCoreException("Can't parse User Role", (Throwable)ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserRole) {
            UserRole userRole = (UserRole)obj;
            return userRole.getGuid().equals(this.getGuid());
        }
        return false;
    }

    public int hashCode() {
        return this.getGuid().hashCode();
    }

    public String toString() {
        return (Object)((Object)this.role) + " - " + this.userId + " - " + this.hoursSpent + " - " + (this.completed != false ? "Completed" : "InWork");
    }

    public ReviewRole getRole() {
        return this.role;
    }

    public void setRole(ReviewRole role) {
        this.role = role;
    }

    public Double getHoursSpent() {
        return this.hoursSpent;
    }

    public void setHoursSpent(Double hoursSpent) {
        this.hoursSpent = hoursSpent;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

