/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.jobs;

import java.rmi.activation.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.core.threading.ThreadedWorkerExecutor;
import org.eclipse.osee.framework.core.threading.ThreadedWorkerFactory;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;

public class FindCommitableJob
extends Job {
    private static final String JOB_NAME = "Check commit allowed";
    private static final String PLUGIN_ID = "org.eclipse.osee.ote.define";
    private final List<Artifact> artifactsToSort;
    private Artifact[] itemsToCommit;
    private Artifact[] nonCommitableItems;
    List<Artifact> commitable;
    List<Artifact> nonCommitable;

    public FindCommitableJob(Artifact ... artifactsToSort) {
        super(JOB_NAME);
        this.setUser(true);
        this.setPriority(30);
        this.artifactsToSort = Arrays.asList(artifactsToSort);
        this.nonCommitableItems = new Artifact[0];
        this.itemsToCommit = this.nonCommitableItems;
    }

    public Artifact[] getAll() {
        return this.artifactsToSort.toArray(new Artifact[this.artifactsToSort.size()]);
    }

    public Artifact[] getCommitAllowed() {
        return this.itemsToCommit;
    }

    public Artifact[] getCommitNotAllowed() {
        return this.nonCommitableItems;
    }

    public IStatus run(final IProgressMonitor monitor) {
        IStatus toReturn = Status.CANCEL_STATUS;
        monitor.beginTask(this.getName(), this.artifactsToSort.size());
        this.commitable = new ArrayList<Artifact>();
        this.nonCommitable = new ArrayList<Artifact>();
        ThreadedWorkerFactory<Object> outfileToArtifactFactory = new ThreadedWorkerFactory<Object>(){

            public int getWorkSize() {
                return FindCommitableJob.this.artifactsToSort.size();
            }

            public Callable<Object> createWorker(int startIndex, int endIndex) {
                return new FindCommitableCallable(FindCommitableJob.this.artifactsToSort.subList(startIndex, endIndex), monitor);
            }
        };
        ThreadedWorkerExecutor executor = new ThreadedWorkerExecutor((ThreadedWorkerFactory)outfileToArtifactFactory, false);
        try {
            executor.executeWorkersBlocking();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return new Status(4, PLUGIN_ID, -1, ex.getLocalizedMessage(), (Throwable)ex);
        }
        this.itemsToCommit = this.commitable.toArray(new Artifact[this.commitable.size()]);
        this.nonCommitableItems = this.nonCommitable.toArray(new Artifact[this.nonCommitable.size()]);
        if (!monitor.isCanceled()) {
            toReturn = Status.OK_STATUS;
        }
        monitor.subTask("Done");
        monitor.done();
        return toReturn;
    }

    private class FindCommitableCallable
    implements Callable<Object> {
        private final List<Artifact> artifactsToSort;
        private final IProgressMonitor monitor;

        public FindCommitableCallable(List<Artifact> artifactsToSort, IProgressMonitor monitor) {
            this.artifactsToSort = artifactsToSort;
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            for (Artifact artifact : this.artifactsToSort) {
                block10: {
                    try {
                        List<Artifact> list;
                        ArtifactTestRunOperator operator = new ArtifactTestRunOperator(artifact);
                        if (operator.isCommitAllowed()) {
                            list = FindCommitableJob.this.commitable;
                            synchronized (list) {
                                FindCommitableJob.this.commitable.add(artifact);
                                break block10;
                            }
                        }
                        list = FindCommitableJob.this.nonCommitable;
                        synchronized (list) {
                            FindCommitableJob.this.nonCommitable.add(artifact);
                        }
                    }
                    catch (OseeArgumentException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
                if (this.monitor.isCanceled()) break;
                this.monitor.worked(1);
            }
            return null;
        }
    }
}

