/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.event;

import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.util.GUID;

public class DefaultBasicGuidArtifact
extends BaseIdentity<String>
implements HasBranchId {
    private final BranchId branch;
    private ArtifactTypeToken artifactType;

    public DefaultBasicGuidArtifact(BranchId branch, ArtifactTypeToken artifactType, String artGuid) {
        super((Object)artGuid);
        this.branch = branch;
        this.artifactType = artifactType;
    }

    public boolean isTypeEqual(ArtifactTypeToken artifactType) {
        return artifactType.equals(this.artifactType);
    }

    public DefaultBasicGuidArtifact(BranchId branch, ArtifactTypeToken artifactType) {
        this(branch, artifactType, GUID.create());
    }

    public DefaultBasicGuidArtifact(BranchId branch, ArtifactToken artifact) {
        this(branch, artifact.getArtifactType(), artifact.getGuid());
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public Long getArtTypeGuid() {
        return this.artifactType.getId();
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public String toString() {
        return String.format("branchId = %s; artType = %s; guid = %s", this.branch.getId(), this.artifactType.getId(), this.getGuid());
    }

    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals && obj instanceof DefaultBasicGuidArtifact) {
            DefaultBasicGuidArtifact other = (DefaultBasicGuidArtifact)((Object)obj);
            return other.artifactType.equals(this.artifactType) && this.isOnSameBranch(other);
        }
        return equals;
    }

    public void setArtTypeGuid(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }
}

