/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix.util;

import java.util.Objects;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class SourceLineVisitor
extends ASTVisitor {
    private final CompilationUnit compilationUnit;
    private final int startLine;
    private final int endLine;
    private ASTNode node = null;

    public SourceLineVisitor(CompilationUnit compilationUnit, int startLine, int endLine) {
        Objects.requireNonNull(compilationUnit, "compilation unit");
        this.compilationUnit = compilationUnit;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public void preVisit(ASTNode node) {
        int lineNumber;
        if (this.node == null && (lineNumber = this.compilationUnit.getLineNumber(node.getStartPosition())) >= this.startLine && lineNumber <= this.endLine) {
            this.node = node;
        }
    }

    public ASTNode getASTNode() {
        return this.node;
    }
}

