/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;

public class RemoveUselessStatementResolution
extends BugResolution {
    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)workingUnit);
        Assert.isNotNull((Object)bug);
        Statement statement = this.findUselessStatement(ASTUtil.getASTNode(workingUnit, bug.getPrimarySourceLineAnnotation()));
        rewrite.remove((ASTNode)statement, null);
    }

    private Statement findUselessStatement(ASTNode node) {
        if (node instanceof Statement) {
            return (Statement)node;
        }
        return null;
    }

    @Override
    protected boolean resolveBindings() {
        return false;
    }
}

