/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public class ChangePublicToProtectedResolution
extends BugResolution {
    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)workingUnit);
        Assert.isNotNull((Object)bug);
        TypeDeclaration type = ASTUtil.getTypeDeclaration(workingUnit, bug.getPrimaryClass());
        MethodDeclaration method = ASTUtil.getMethodDeclaration(type, bug.getPrimaryMethod());
        Modifier originalModifier = this.getPublicModifier(method);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)method, MethodDeclaration.MODIFIERS2_PROPERTY);
        Modifier protectedModifier = workingUnit.getAST().newModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        listRewrite.replace((ASTNode)originalModifier, (ASTNode)protectedModifier, null);
    }

    private Modifier getPublicModifier(MethodDeclaration method) {
        List list = method.modifiers();
        for (Object o : list) {
            Modifier mdf;
            if (!o.getClass().equals(Modifier.class) || !(mdf = (Modifier)o).getKeyword().equals(Modifier.ModifierKeyword.PUBLIC_KEYWORD)) continue;
            return mdf;
        }
        return null;
    }

    @Override
    protected boolean resolveBindings() {
        return true;
    }
}

