/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.QuickFixContribution;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IMarkerResolution;

public class BugResolutionAssociations {
    private final Map<String, List<QuickFixContribution>> quickFixes;

    protected BugResolutionAssociations(Map<String, List<QuickFixContribution>> quickFixes) {
        this.quickFixes = quickFixes;
    }

    public boolean containsBugResolution(String bugType) {
        Assert.isNotNull((Object)bugType);
        return this.quickFixes.containsKey(bugType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, List<QuickFixContribution>>> set = this.quickFixes.entrySet();
        for (Map.Entry<String, List<QuickFixContribution>> entry : set) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public IMarkerResolution[] createBugResolutions(String bugType, IMarker marker) {
        Assert.isNotNull((Object)bugType);
        Assert.isNotNull((Object)marker);
        List<QuickFixContribution> classes = this.quickFixes.get(bugType);
        if (classes == null) {
            return new IMarkerResolution[0];
        }
        Set<BugResolution> fixes = BugResolutionAssociations.instantiateBugResolutions(classes);
        Iterator<BugResolution> iterator = fixes.iterator();
        while (iterator.hasNext()) {
            BugResolution fix = iterator.next();
            if (fix.isApplicable(marker)) {
                fix.setMarker(marker);
                continue;
            }
            iterator.remove();
        }
        return fixes.toArray(new IMarkerResolution[fixes.size()]);
    }

    private static Set<BugResolution> instantiateBugResolutions(List<QuickFixContribution> quicks) {
        Assert.isNotNull(quicks);
        HashSet<BugResolution> fixes = new HashSet<BugResolution>();
        for (QuickFixContribution qf : quicks) {
            BugResolution fixer = BugResolutionAssociations.instantiateBugResolution(qf);
            if (fixer == null) continue;
            fixes.add(fixer);
        }
        return fixes;
    }

    @CheckForNull
    private static BugResolution instantiateBugResolution(QuickFixContribution qf) {
        try {
            BugResolution br = qf.producer.call();
            br.setLabel(qf.label);
            br.setBugPattern(qf.pattern);
            br.setOptions(qf.args);
            return br;
        }
        catch (Throwable e) {
            FindbugsPlugin.getDefault().logException(e, "Failed to create bug-resolution '" + qf + "'.");
            return null;
        }
    }
}

