/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class ConfidenceMatcher
implements Matcher {
    private final int confidence;

    public String toString() {
        return "Confidence(confidence=" + this.confidence + ")";
    }

    public ConfidenceMatcher(String confidenceAsString) {
        this.confidence = Integer.parseInt(confidenceAsString);
    }

    public int hashCode() {
        return this.confidence;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConfidenceMatcher)) {
            return false;
        }
        ConfidenceMatcher other = (ConfidenceMatcher)o;
        return this.confidence == other.confidence;
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        return bugInstance.getPriority() == this.confidence;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("value", Integer.toString(this.confidence));
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Confidence", attributes);
    }
}

