/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InheritanceUnsafeGetResource
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private boolean classIsFinal;
    private boolean classIsVisibleToOtherPackages;
    private boolean methodIsStatic;
    int state = 0;
    int sawGetClass;
    boolean reportedForThisClass;
    String stringConstant;
    int prevOpcode;

    public InheritanceUnsafeGetResource(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(JavaClass obj) {
        this.classIsFinal = obj.isFinal();
        this.reportedForThisClass = false;
        this.classIsVisibleToOtherPackages = obj.isPublic() || obj.isProtected();
    }

    @Override
    public void visit(Method obj) {
        this.methodIsStatic = obj.isStatic();
        this.state = 0;
        this.sawGetClass = -100;
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.reportedForThisClass) {
            return;
        }
        switch (seen) {
            case 18: {
                Constant constantValue = this.getConstantRefOperand();
                if (constantValue instanceof ConstantClass) {
                    this.sawGetClass = -100;
                    break;
                }
                if (!(constantValue instanceof ConstantString)) break;
                this.stringConstant = ((ConstantString)constantValue).getBytes(this.getConstantPool());
                break;
            }
            case 42: {
                this.state = 1;
                break;
            }
            case 182: {
                if ("java/lang/Class".equals(this.getClassConstantOperand()) && ("getResource".equals(this.getNameConstantOperand()) || "getResourceAsStream".equals(this.getNameConstantOperand())) && this.sawGetClass + 10 >= this.getPC()) {
                    int priority = 2;
                    priority = this.prevOpcode == 18 && this.stringConstant != null && this.stringConstant.length() > 0 && this.stringConstant.charAt(0) == '/' ? 3 : this.adjustPriority(priority);
                    this.bugReporter.reportBug(new BugInstance(this, "UI_INHERITANCE_UNSAFE_GETRESOURCE", priority).addClassAndMethod(this).addSourceLine(this));
                    this.reportedForThisClass = true;
                } else if (this.state == 1 && !this.methodIsStatic && !this.classIsFinal && this.classIsVisibleToOtherPackages && "getClass".equals(this.getNameConstantOperand()) && "()Ljava/lang/Class;".equals(this.getSigConstantOperand())) {
                    this.sawGetClass = this.getPC();
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
        if (seen != 18) {
            this.stringConstant = null;
        }
        this.prevOpcode = seen;
    }

    private int adjustPriority(int priority) {
        block4: {
            try {
                Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                if (!subtypes2.hasSubtypes(this.getClassDescriptor())) {
                    ++priority;
                    break block4;
                }
                Set<ClassDescriptor> mySubtypes = subtypes2.getSubtypes(this.getClassDescriptor());
                String myPackagename = this.getThisClass().getPackageName();
                for (ClassDescriptor c : mySubtypes) {
                    if (c.equals(this.getClassDescriptor()) || c.getPackageName().equals(myPackagename)) continue;
                    --priority;
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        return priority;
    }
}

