/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

public class ComparatorIdiom
extends PreorderVisitor
implements Detector {
    BugReporter bugReporter;

    public ComparatorIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    @Override
    public void visit(JavaClass obj) {
        if (Subtypes2.instanceOf(obj, "java.util.Comparator") && !ClassName.isAnonymous(this.getClassName()) && !Subtypes2.instanceOf(obj, "java.io.Serializable")) {
            int priority = 2;
            if (obj.isInterface() || obj.isAbstract()) {
                return;
            }
            double easilySerializable = 1.0;
            for (Field f : obj.getFields()) {
                try {
                    if (f.getName().startsWith("this$")) {
                        return;
                    }
                    String signature = f.getSignature();
                    char firstChar = signature.charAt(0);
                    if (firstChar != 'L' && firstChar != '[') continue;
                    easilySerializable *= DeepSubtypeAnalysis.isDeepSerializable(signature);
                }
                catch (ClassNotFoundException e) {
                    easilySerializable = 0.0;
                    break;
                }
            }
            if (easilySerializable < 0.9) {
                priority = 3;
            }
            this.bugReporter.reportBug(new BugInstance(this, "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE", priority).addClass(this));
        }
    }

    @Override
    public void report() {
    }
}

