/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ReverseDFSOrder;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.npe.ReturnPathType;
import org.apache.bcel.generic.InstructionHandle;

public class ReturnPathTypeAnalysis
extends BasicAbstractDataflowAnalysis<ReturnPathType> {
    private final CFG cfg;
    private final DepthFirstSearch dfs;
    private final ReverseDepthFirstSearch rdfs;

    public ReturnPathTypeAnalysis(CFG cfg, ReverseDepthFirstSearch rdfs, DepthFirstSearch dfs) {
        this.cfg = cfg;
        this.dfs = dfs;
        this.rdfs = rdfs;
    }

    @Override
    public void copy(ReturnPathType source, ReturnPathType dest) {
        dest.copyFrom(source);
    }

    @Override
    public ReturnPathType createFact() {
        ReturnPathType fact = new ReturnPathType();
        fact.setTop();
        return fact;
    }

    @Override
    public void edgeTransfer(Edge edge, ReturnPathType fact) {
        if (edge.getTarget() == this.cfg.getExit()) {
            fact.setCanReturnNormally(!edge.isExceptionEdge());
        }
    }

    @Override
    public void finishIteration() {
    }

    @Override
    public BlockOrder getBlockOrder(CFG cfg) {
        return new ReverseDFSOrder(cfg, this.rdfs, this.dfs);
    }

    @Override
    public int getLastUpdateTimestamp(ReturnPathType fact) {
        return 0;
    }

    @Override
    public void initEntryFact(ReturnPathType result) throws DataflowAnalysisException {
        result.setCanReturnNormally(true);
    }

    @Override
    public boolean isForwards() {
        return false;
    }

    @Override
    public boolean isTop(ReturnPathType fact) {
        return fact.isTop();
    }

    @Override
    public void makeFactTop(ReturnPathType fact) {
        fact.setTop();
    }

    @Override
    public void meetInto(ReturnPathType fact, Edge edge, ReturnPathType result) throws DataflowAnalysisException {
        result.mergeWith(fact);
    }

    @Override
    public boolean same(ReturnPathType fact1, ReturnPathType fact2) {
        return fact1.sameAs(fact2);
    }

    @Override
    public void setLastUpdateTimestamp(ReturnPathType fact, int timestamp) {
    }

    @Override
    public void startIteration() {
    }

    @Override
    public void transfer(BasicBlock basicBlock, InstructionHandle end, ReturnPathType start, ReturnPathType result) throws DataflowAnalysisException {
        result.copyFrom(start);
    }
}

