/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.visitclass.Constants2;
import javax.annotation.CheckForNull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class Lookup
implements Constants2 {
    public static XClass getXClass(ClassDescriptor c) throws CheckedAnalysisException {
        return Global.getAnalysisCache().getClassAnalysis(XClass.class, c);
    }

    public static XClass getXClass(@SlashedClassName String className) throws CheckedAnalysisException {
        return Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptor(className));
    }

    public static XClass findSuperImplementor(XClass clazz, String name, String signature, boolean isStatic, BugReporter bugReporter) {
        try {
            return Lookup.findSuperImplementor(clazz, name, signature, isStatic);
        }
        catch (MissingClassException e) {
            bugReporter.reportMissingClass(e.getClassDescriptor());
            return clazz;
        }
        catch (CheckedAnalysisException e) {
            bugReporter.logError("Error finding " + clazz + "." + name + signature, e);
            return clazz;
        }
    }

    public static XClass findImplementor(XClass clazz, String name, String signature, boolean isStatic, BugReporter bugReporter) {
        try {
            return Lookup.findImplementor(clazz, name, signature, isStatic);
        }
        catch (MissingClassException e) {
            bugReporter.reportMissingClass(e.getClassDescriptor());
            return clazz;
        }
        catch (CheckedAnalysisException e) {
            bugReporter.logError("Error finding " + clazz + "." + name + signature, e);
            return clazz;
        }
    }

    public static XClass findSuperImplementor(XClass clazz, String name, String signature, boolean isStatic) throws CheckedAnalysisException {
        ClassDescriptor superclassDescriptor = clazz.getSuperclassDescriptor();
        if (superclassDescriptor == null) {
            return clazz;
        }
        return Lookup.findImplementor(Lookup.getXClass(superclassDescriptor), name, signature, isStatic);
    }

    public static XClass findImplementor(XClass clazz, String name, String signature, boolean isStatic) throws CheckedAnalysisException {
        XMethod m = clazz.findMethod(name, signature, isStatic);
        if (m != null) {
            return clazz;
        }
        return Lookup.findSuperImplementor(clazz, name, signature, isStatic);
    }

    @CheckForNull
    public static JavaClass findSuperDefiner(JavaClass clazz, String name, String signature, BugReporter bugReporter) {
        try {
            Method m;
            JavaClass c = clazz;
            do {
                if ((c = c.getSuperClass()) != null) continue;
                return null;
            } while ((m = Lookup.findImplementation(c, name, signature)) == null);
            return c;
        }
        catch (ClassNotFoundException e) {
            bugReporter.reportMissingClass(e);
            return null;
        }
    }

    @CheckForNull
    public static JavaClass findSuperImplementor(JavaClass clazz, String name, String signature, BugReporter bugReporter) {
        try {
            Method m;
            JavaClass c = clazz;
            do {
                if ((c = c.getSuperClass()) != null) continue;
                return null;
            } while ((m = Lookup.findImplementation(c, name, signature)) == null || m.isAbstract());
            return c;
        }
        catch (ClassNotFoundException e) {
            bugReporter.reportMissingClass(e);
            return null;
        }
    }

    @CheckForNull
    public static XMethod findSuperImplementorAsXMethod(JavaClass clazz, String name, String signature, BugReporter bugReporter) {
        try {
            Method m;
            JavaClass c = clazz;
            do {
                if ((c = c.getSuperClass()) != null) continue;
                return null;
            } while ((m = Lookup.findImplementation(c, name, signature)) == null || m.isAbstract());
            return XFactory.createXMethod(c, m);
        }
        catch (ClassNotFoundException e) {
            bugReporter.reportMissingClass(e);
            return null;
        }
    }

    @DottedClassName
    public static String findSuperImplementor(@DottedClassName String clazz, String name, String signature, BugReporter bugReporter) {
        try {
            JavaClass c = Lookup.findImplementor(Repository.getSuperClasses((String)clazz), name, signature);
            return c != null ? c.getClassName() : clazz;
        }
        catch (ClassNotFoundException e) {
            bugReporter.reportMissingClass(e);
            return clazz;
        }
    }

    @CheckForNull
    public static JavaClass findImplementor(JavaClass[] clazz, String name, String signature) {
        for (JavaClass aClazz : clazz) {
            Method m = Lookup.findImplementation(aClazz, name, signature);
            if (m == null || m.isAbstract()) continue;
            return aClazz;
        }
        return null;
    }

    public static Method findImplementation(JavaClass clazz, String name, String signature) {
        Method[] m;
        for (Method aM : m = clazz.getMethods()) {
            if (!aM.getName().equals(name) || !aM.getSignature().equals(signature) || aM.isPrivate() || aM.isStatic()) continue;
            return aM;
        }
        return null;
    }
}

