/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.EditorUtil;
import de.tobject.findbugs.view.explorer.BugContentProvider;
import de.tobject.findbugs.view.explorer.BugGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class BugActionProvider
extends CommonActionProvider {
    private WorkingSetFilterActionGroup workingSetActionGroup;
    private IPropertyChangeListener filterChangeListener;
    boolean hasContributedToViewMenu;
    private MyAction doubleClickAction;
    private ICommonActionExtensionSite site;
    private boolean initDone;

    public void init(ICommonActionExtensionSite aSite) {
        this.site = aSite;
        super.init(aSite);
        final StructuredViewer viewer = aSite.getStructuredViewer();
        final BugContentProvider provider = BugContentProvider.getProvider(this.site.getContentService());
        this.filterChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!BugActionProvider.this.initDone) {
                    return;
                }
                IWorkingSet oldWorkingSet = provider.getCurrentWorkingSet();
                IWorkingSet oldWorkingSet1 = (IWorkingSet)event.getOldValue();
                IWorkingSet newWorkingSet = (IWorkingSet)event.getNewValue();
                if (newWorkingSet != null && (oldWorkingSet == newWorkingSet || oldWorkingSet1 == newWorkingSet)) {
                    return;
                }
                if (viewer != null) {
                    provider.setCurrentWorkingSet(newWorkingSet);
                    if (newWorkingSet == null) {
                        viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                    } else if (oldWorkingSet != newWorkingSet) {
                        viewer.setInput((Object)newWorkingSet);
                    }
                }
            }
        };
        this.workingSetActionGroup = new WorkingSetFilterActionGroup(aSite.getViewSite().getShell(), this.filterChangeListener);
        if (provider == null) {
            throw new NullPointerException("no provider");
        }
        this.workingSetActionGroup.setWorkingSet(provider.getCurrentWorkingSet());
        this.doubleClickAction = new MyAction();
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.doubleClickAction);
        this.initDone = true;
    }

    public void dispose() {
        this.site.getStructuredViewer().removeSelectionChangedListener((ISelectionChangedListener)this.doubleClickAction);
        super.dispose();
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (!this.hasContributedToViewMenu) {
            IMenuManager mm;
            IContributionItem item;
            IContributionItem[] items;
            IMenuManager menuManager = actionBars.getMenuManager();
            for (IContributionItem item2 : items = menuManager.getItems()) {
                ActionContributionItem item22;
                String text;
                if (!(item2 instanceof ActionContributionItem) || !"Customize View...".equals(text = (item22 = (ActionContributionItem)item2).getAction().getText()) && !"&Customize View...".equals(text)) continue;
                item22.getAction().setText("Toggle Filters...");
                break;
            }
            if ((item = menuManager.find("findBugsEclipsePlugin.toggleGrouping.groupDialog")) != null) {
                menuManager.remove(item);
                menuManager.insertBefore("additions", item);
            }
            if ((mm = menuManager.findMenuUsingPath("bugExplorer.menu.group")) != null) {
                menuManager.remove((IContributionItem)mm);
                menuManager.insertBefore("additions", (IContributionItem)mm);
            }
            this.workingSetActionGroup.fillActionBars(actionBars);
            this.hasContributedToViewMenu = true;
        }
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.doubleClickAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.insertBefore("group.port", (IContributionItem)new Separator("fb"));
        menu.insertBefore("group.port", (IContributionItem)new Separator("fb.project"));
        menu.insertBefore("group.port", (IContributionItem)new Separator("fb.filter"));
    }

    static class MyAction
    extends Action
    implements ISelectionChangedListener {
        private IMarker marker;
        private IFile file;
        private IJavaElement javaElement;

        MyAction() {
        }

        public void run() {
            if (this.marker == null && this.file == null && this.javaElement == null) {
                return;
            }
            try {
                if (this.javaElement != null) {
                    IEditorPart editor = JavaUI.openInEditor((IJavaElement)this.javaElement, (boolean)true, (boolean)true);
                    if (editor instanceof ITextEditor && this.marker != null) {
                        EditorUtil.goToLine(editor, this.marker.getAttribute("lineNumber", 1));
                    }
                } else if (this.marker != null) {
                    IDE.openEditor((IWorkbenchPage)FindbugsPlugin.getActiveWorkbenchWindow().getActivePage(), (IMarker)this.marker, (boolean)true);
                } else {
                    IDE.openEditor((IWorkbenchPage)FindbugsPlugin.getActiveWorkbenchWindow().getActivePage(), (IFile)this.file, (boolean)true);
                }
            }
            catch (PartInitException e) {
                FindbugsPlugin.getDefault().logException(e, "Cannot open editor for marker: " + this.marker);
            }
            catch (JavaModelException e) {
                FindbugsPlugin.getDefault().logException(e, "Cannot open editor for java element: " + this.javaElement);
            }
        }

        void setSelection(IMarker sel) {
            this.marker = sel;
            this.javaElement = MarkerUtil.findJavaElementForMarker(this.marker);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection ss;
            this.resetSelection();
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                Object firstElement = ss.getFirstElement();
                if (firstElement instanceof IMarker) {
                    this.setSelection((IMarker)firstElement);
                } else if (firstElement instanceof BugGroup) {
                    IAdaptable adaptable;
                    Object adapter;
                    BugGroup group = (BugGroup)firstElement;
                    Object data = group.getData();
                    if (data instanceof IJavaElement) {
                        this.javaElement = (IJavaElement)data;
                    }
                    if (data instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)data).getAdapter(IResource.class)) instanceof IFile) {
                        this.file = (IFile)adapter;
                    }
                }
            }
        }

        private void resetSelection() {
            this.marker = null;
            this.file = null;
            this.javaElement = null;
        }
    }
}

