/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.explorer.BugGroup;
import de.tobject.findbugs.view.explorer.BugLabelProvider;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.Plugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.IStructuredSelection;

public class PropPageTitleProvider
extends BugLabelProvider {
    @Override
    public String getText(Object element) {
        String title;
        if (element instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)element;
            if (selection.size() > 1) {
                return super.getText(element);
            }
            element = selection.getFirstElement();
        }
        if ((title = this.getTitle(element)) != null) {
            return title;
        }
        return super.getText(element);
    }

    String getTitle(Object something) {
        if (something instanceof BugGroup) {
            return this.getTitle((BugGroup)something);
        }
        if (something instanceof IMarker) {
            return this.getTitle((IMarker)something);
        }
        return null;
    }

    String getTitle(IMarker marker) {
        return this.getTitle(MarkerUtil.findBugInstanceForMarker(marker));
    }

    String getTitle(BugGroup group) {
        Object data = group.getData();
        if (data == null) {
            return null;
        }
        switch (group.getType()) {
            case Marker: {
                return this.getTitle((IMarker)data);
            }
            case Pattern: {
                return this.getTitle((BugPattern)data);
            }
            case PatternType: {
                return this.getTitle((BugCode)data);
            }
            case Category: {
                return this.getTitle((BugCategory)data);
            }
            case Confidence: {
                return this.getTitle((FindBugsMarker.MarkerConfidence)((Object)data));
            }
            case BugRank: {
                return this.getTitle((FindBugsMarker.MarkerRank)((Object)data));
            }
            case Package: {
                return this.getTitle((IPackageFragment)data);
            }
            case Project: {
                return this.getTitle((IProject)data);
            }
            case Class: {
                return this.getTitle((IJavaElement)data);
            }
            case DetectorPlugin: {
                return this.getTitle((Plugin)data);
            }
        }
        return null;
    }

    String getTitle(IJavaElement elem) {
        if (elem == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Class: ");
        sb.append(elem.getElementName());
        return sb.toString();
    }

    String getTitle(IProject pack) {
        if (pack == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Project: ");
        sb.append(pack.getName());
        return sb.toString();
    }

    String getTitle(IPackageFragment pack) {
        if (pack == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Package: ");
        String name = pack.getElementName();
        if (name == null || name.length() == 0) {
            sb.append("default package");
        } else {
            sb.append(name);
        }
        return sb.toString();
    }

    String getTitle(FindBugsMarker.MarkerConfidence priority) {
        if (priority == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Confidence: ");
        sb.append(priority.name());
        return sb.toString();
    }

    String getTitle(FindBugsMarker.MarkerRank rank) {
        if (rank == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Rank: ");
        sb.append(rank.name());
        return sb.toString();
    }

    String getTitle(BugCategory category) {
        if (category == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Category: ");
        sb.append(category.getShortDescription());
        sb.append(" (").append(category.getAbbrev()).append(", ");
        sb.append(category.getCategory()).append(")");
        return sb.toString();
    }

    String getTitle(BugCode type) {
        if (type == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Pattern Type: ");
        sb.append(type.getDescription());
        sb.append(" (").append(type.getAbbrev()).append(")");
        return sb.toString();
    }

    String getTitle(BugPattern pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Pattern: ");
        sb.append(pattern.getShortDescription());
        return sb.toString();
    }

    String getTitle(BugInstance bug) {
        if (bug == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Bug: ");
        sb.append(bug.getAbridgedMessage());
        return sb.toString();
    }

    String getTitle(Plugin plugin) {
        if (plugin == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Plugin: ");
        sb.append(plugin.getPluginId());
        sb.append(" (provider: ");
        sb.append(plugin.getProvider()).append(")");
        return sb.toString();
    }

    String getDetails(BugInstance bug) {
        if (bug == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BugPattern pattern = bug.getBugPattern();
        sb.append(" (").append(pattern.getType());
        sb.append(", ").append(pattern.getAbbrev()).append(", ");
        sb.append(pattern.getCategory()).append(", ");
        sb.append(bug.getPriorityString());
        sb.append(")");
        return sb.toString();
    }

    public String getDetails(BugPattern pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<b>id:</b> ");
        sb.append(pattern.getType());
        sb.append(", <b>type:</b> ").append(pattern.getAbbrev()).append(", <b>category:</b> ");
        sb.append(pattern.getCategory());
        return sb.toString();
    }
}

