/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.properties.DetectorProvider;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import de.tobject.findbugs.properties.ManagePathsWidget;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.config.UserPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class WorkspaceSettingsTab
extends Composite {
    private Button confirmSwitch;
    private Button switchTo;
    private final IPreferenceStore store;
    private Button confirmBuild;
    private final FindbugsPropertyPage page;
    private DetectorProvider detectorProvider;
    private Button cacheClassData;
    private Button runAsExtraJob;

    public WorkspaceSettingsTab(TabFolder tabFolder, FindbugsPropertyPage page, int style) {
        super((Composite)tabFolder, style);
        this.page = page;
        this.setLayout((Layout)new GridLayout());
        this.store = page.getPreferenceStore();
        TabItem tabDetector = new TabItem(tabFolder, 0);
        tabDetector.setText("Plugins and misc. Settings");
        tabDetector.setControl((Control)this);
        Label versionLabel = new Label((Composite)this, 0);
        versionLabel.setText("FindBugs version: " + Version.RELEASE);
        this.runAsExtraJob = new Button((Composite)this, 32);
        this.runAsExtraJob.setSelection(this.store.getBoolean("runAnalysisAsExtraJob"));
        this.runAsExtraJob.setText("Run FB analysis as extra job (independent from build job)");
        this.runAsExtraJob.setToolTipText("Should improve user experience especially for the incremented compile");
        this.cacheClassData = new Button((Composite)this, 32);
        this.cacheClassData.setSelection(this.store.getBoolean("cacheClassData"));
        this.cacheClassData.setText("Cache .class data (useful for slow file system && lot of RAM) (experimental)");
        this.cacheClassData.setToolTipText("Reuse .class data for the next FindBugs analysis. The cache will survive until the next project build.");
        if (!this.isWorkspaceSettings()) {
            Label lbl = new Label((Composite)this, 64);
            lbl.setText("Currently, plugins can only be updated from the workspace settings");
            return;
        }
        ManagePathsWidget pathsWidget = new ManagePathsWidget(this);
        CheckboxTableViewer viewer = pathsWidget.createViewer("FindBugs Plugins", "See: <a href=\"http://www.ibm.com/developerworks/library/j-findbug2/\">'Writing custom plugins'</a> and <a href=\"http://fb-contrib.sourceforge.net/\">fb-contrib</a>: additional bug detectors package", true);
        this.detectorProvider = this.createDetectorProvider(viewer);
        pathsWidget.createButtonsArea(this.detectorProvider);
        this.detectorProvider.refresh();
        this.switchTo = new Button((Composite)this, 32);
        this.switchTo.setText("Switch to the FindBugs perspective after analysis");
        this.switchTo.setSelection(this.store.getBoolean("switchPerspectiveAfterAnalysis"));
        this.switchTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceSettingsTab.this.store.setValue("switchPerspectiveAfterAnalysis", WorkspaceSettingsTab.this.switchTo.getSelection());
            }
        });
        this.confirmSwitch = new Button((Composite)this, 32);
        this.confirmSwitch.setText("Ask before switching to the FindBugs perspective");
        this.confirmSwitch.setSelection(this.store.getBoolean("askAboutPerspectiveSwitch"));
        this.confirmSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceSettingsTab.this.store.setValue("askAboutPerspectiveSwitch", WorkspaceSettingsTab.this.confirmSwitch.getSelection());
            }
        });
        this.confirmBuild = new Button((Composite)this, 32);
        this.confirmBuild.setText("Remind to redo analysis after changes of relevant settings");
        this.confirmBuild.setSelection(!this.store.getBoolean("dontRemindAboutFullBuild"));
        this.confirmBuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceSettingsTab.this.store.setValue("dontRemindAboutFullBuild", !WorkspaceSettingsTab.this.confirmBuild.getSelection());
            }
        });
    }

    protected DetectorProvider createDetectorProvider(CheckboxTableViewer viewer) {
        final DetectorProvider filterProvider = new DetectorProvider(viewer, this.page);
        filterProvider.addListener(new Listener(){

            public void handleEvent(Event event) {
                WorkspaceSettingsTab.this.page.setErrorMessage(null);
                filterProvider.refresh();
            }
        });
        return filterProvider;
    }

    public void refreshUI(UserPreferences prefs) {
        this.cacheClassData.setSelection(this.store.getBoolean("cacheClassData"));
        this.runAsExtraJob.setSelection(this.store.getBoolean("runAnalysisAsExtraJob"));
        if (!this.isWorkspaceSettings()) {
            return;
        }
        this.confirmSwitch.setSelection(this.store.getBoolean("askAboutPerspectiveSwitch"));
        this.switchTo.setSelection(this.store.getBoolean("switchPerspectiveAfterAnalysis"));
        this.confirmBuild.setSelection(!this.store.getBoolean("dontRemindAboutFullBuild"));
        this.detectorProvider.setDetectorPlugins(prefs);
        this.detectorProvider.refresh();
    }

    private boolean isWorkspaceSettings() {
        return this.page.getProject() == null;
    }

    public void performOK() {
        this.store.setValue("cacheClassData", this.cacheClassData.getSelection());
        this.store.setValue("runAnalysisAsExtraJob", this.runAsExtraJob.getSelection());
        if (!this.isWorkspaceSettings()) {
            return;
        }
    }
}

