/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.properties.IPathElement;
import de.tobject.findbugs.properties.PathElementLabelProvider;
import de.tobject.findbugs.properties.PathsProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;

public class ManagePathsWidget
extends Composite {
    private TableViewer viewer;

    public ManagePathsWidget(Composite parent) {
        super(parent, 0);
    }

    public CheckboxTableViewer createViewer(String title, String linkText, boolean withCheckBox) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        Label titleLabel = new Label((Composite)this, 0);
        titleLabel.setText(title);
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        if (linkText != null) {
            Link details = new Link((Composite)this, 0);
            details.setText(linkText);
            details.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            details.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Program.launch((String)e.text);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        int style = 2818;
        if (withCheckBox) {
            style |= 0x20;
        }
        Table table = new Table((Composite)this, style);
        CheckboxTableViewer viewer1 = new CheckboxTableViewer(table);
        viewer1.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        final PathElementLabelProvider labelProvider = new PathElementLabelProvider();
        viewer1.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer = viewer1;
        viewer1.getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                String tooltip = "";
                ViewerCell cell = ManagePathsWidget.this.viewer.getCell(new Point(e.x, e.y));
                if (cell != null) {
                    tooltip = labelProvider.getToolTip(cell.getElement());
                }
                ManagePathsWidget.this.viewer.getControl().setToolTipText(tooltip);
            }

            public void mouseExit(MouseEvent e) {
                ManagePathsWidget.this.viewer.getControl().setToolTipText("");
            }
        });
        return viewer1;
    }

    public TableViewer createViewer(String title, String linkText) {
        return this.createViewer(title, linkText, false);
    }

    public void createButtonsArea(PathsProvider contentProvider) {
        Button addButton = new Button((Composite)this, 8);
        String addButtonLabel = ManagePathsWidget.getMessage("property.addbutton");
        addButton.setText(addButtonLabel);
        addButton.setData((Object)"add");
        addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        addButton.addSelectionListener((SelectionListener)contentProvider);
        final Button removeButton = new Button((Composite)this, 8);
        removeButton.setLayoutData((Object)new GridData(4, 1, false, true));
        String removeButtonLabel = ManagePathsWidget.getMessage("property.removebutton");
        removeButton.setText(removeButtonLabel);
        removeButton.setData((Object)"remove");
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)contentProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    removeButton.setEnabled(false);
                } else if (selection.getFirstElement() instanceof IPathElement) {
                    IPathElement pathElement = (IPathElement)selection.getFirstElement();
                    removeButton.setEnabled(!pathElement.isSystem());
                }
            }
        });
    }

    protected static String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }
}

