/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.util.Archive;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class WorkItem {
    private final IJavaElement javaElt;
    private final IResource resource;
    private final IProject project;

    public WorkItem(IJavaElement javaElt) {
        this(null, javaElt, javaElt.getJavaProject().getProject());
    }

    public WorkItem(IResource resource) {
        this(resource, null, resource.getProject());
    }

    private WorkItem(IResource resource, IJavaElement javaElt, IProject project) {
        this.resource = resource;
        this.javaElt = javaElt;
        this.project = project;
        Assert.isLegal((resource != null || javaElt != null ? 1 : 0) != 0);
    }

    public void addFilesToProject(Project fbProject, Map<IPath, IPath> outputLocations) {
        IResource res = this.getCorespondingResource();
        if (res instanceof IProject) {
            for (IPath outDir : outputLocations.values()) {
                fbProject.addFile(outDir.toOSString());
            }
        } else if (res instanceof IFolder) {
            boolean added = WorkItem.addClassesForFolder((IFolder)res, outputLocations, fbProject);
            if (!added) {
                this.addJavaElementPath(fbProject);
            }
        } else if (res instanceof IFile) {
            if (Util.isClassFile(res) || Util.isJavaArchive(res)) {
                fbProject.addFile(res.getLocation().toOSString());
            } else if (Util.isJavaFile(res)) {
                WorkItem.addClassesForFile((IFile)res, outputLocations, fbProject);
            }
        } else {
            this.addJavaElementPath(fbProject);
        }
    }

    private void addJavaElementPath(Project fbProject) {
        IPath path;
        if (this.javaElt != null && (path = this.getPath()) != null) {
            fbProject.addFile(path.toOSString());
        }
    }

    public void clearMarkers() throws CoreException {
        IResource res = this.getMarkerTarget();
        if (this.javaElt == null || !(res instanceof IProject)) {
            MarkerUtil.removeMarkers(res);
        } else {
            IMarker[] allMarkers = MarkerUtil.getAllMarkers(res);
            Set<IMarker> set = MarkerUtil.findMarkerForJavaElement(this.javaElt, allMarkers, true);
            for (IMarker marker : set) {
                marker.delete();
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.project);
    }

    private static boolean addClassesForFolder(IFolder folder, Map<IPath, IPath> outLocations, Project fbProject) {
        IPath path = folder.getLocation();
        IPath srcRoot = WorkItem.getMatchingSourceRoot(path, outLocations);
        if (srcRoot == null) {
            return false;
        }
        IPath outputRoot = outLocations.get(srcRoot);
        int firstSegments = path.matchingFirstSegments(srcRoot);
        IPath out = outputRoot.append(path.removeFirstSegments(firstSegments));
        File directory = out.toFile();
        return fbProject.addFile(directory.getAbsolutePath());
    }

    private static void addClassesForFile(IFile file, Map<IPath, IPath> outLocations, Project fbProject) {
        IPath path = file.getLocation();
        IPath srcRoot = WorkItem.getMatchingSourceRoot(path, outLocations);
        if (srcRoot == null) {
            return;
        }
        IPath outputRoot = outLocations.get(srcRoot);
        int firstSegments = path.matchingFirstSegments(srcRoot);
        IPath out = outputRoot.append(path.removeFirstSegments(firstSegments));
        String fileName = path.removeFileExtension().lastSegment();
        String namePattern = fileName + "\\.class|" + fileName + "\\$.*\\.class";
        namePattern = WorkItem.addSecondaryTypesToPattern(file, fileName, namePattern);
        File directory = out.removeLastSegments(1).toFile();
        Pattern classNamesPattern = Pattern.compile(namePattern);
        ResourceUtils.addFiles(fbProject, directory, classNamesPattern);
    }

    private static String addSecondaryTypesToPattern(IFile file, String fileName, String classNamePattern) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
        if (cu == null) {
            FindbugsPlugin.getDefault().logError("NULL compilation unit for " + file + ", FB analysis might  be incomplete for included types");
            return classNamePattern;
        }
        try {
            IType[] types = cu.getTypes();
            if (types.length > 1) {
                StringBuilder sb = new StringBuilder(classNamePattern);
                for (IType type : types) {
                    if (fileName.equals(type.getElementName())) continue;
                    sb.append("|").append(type.getElementName());
                    sb.append("\\.class|").append(type.getElementName());
                    sb.append("\\$.*\\.class");
                }
                classNamePattern = sb.toString();
            }
        }
        catch (JavaModelException e) {
            FindbugsPlugin.getDefault().logException(e, "Cannot get types from compilation unit: " + cu);
        }
        return classNamePattern;
    }

    @CheckForNull
    public IResource getCorespondingResource() {
        if (this.resource != null) {
            return this.resource;
        }
        try {
            IResource resource1 = this.javaElt.getCorrespondingResource();
            if (resource1 != null) {
                return resource1;
            }
            IJavaElement ancestor = this.javaElt.getAncestor(5);
            if (ancestor != null) {
                return ancestor.getCorrespondingResource();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    @CheckForNull
    public IJavaElement getCorespondingJavaElement() {
        if (this.javaElt != null) {
            return this.javaElt;
        }
        return JavaCore.create((IResource)this.resource);
    }

    @Nonnull
    public IResource getMarkerTarget() {
        IResource resource2;
        IResource res = this.getCorespondingResource();
        if (res != null) {
            return res;
        }
        if (this.javaElt != null && (resource2 = this.javaElt.getResource()) != null) {
            return resource2;
        }
        return this.project;
    }

    public int getMarkerCount(boolean recursive) {
        return this.getMarkers(recursive).size();
    }

    public Set<IMarker> getMarkers(boolean recursive) {
        IResource res = this.getCorespondingResource();
        if (res != null) {
            if (res.getType() == 4 || this.javaElt instanceof IPackageFragmentRoot) {
                recursive = true;
            }
            IMarker[] markers = MarkerUtil.getMarkers(res, recursive ? 2 : 1);
            return new HashSet<IMarker>(Arrays.asList(markers));
        }
        IResource markerTarget = this.getMarkerTarget();
        if (!markerTarget.isAccessible()) {
            return Collections.emptySet();
        }
        if (!recursive && (markerTarget.getType() == 4 && this.javaElt instanceof IPackageFragmentRoot || Util.isClassFile(this.javaElt) || Util.isJavaArchive(markerTarget) && Util.isClassFile(this.javaElt))) {
            recursive = true;
        }
        IMarker[] markers = MarkerUtil.getMarkers(markerTarget, recursive ? 2 : 1);
        Set<IMarker> forJavaElement = MarkerUtil.findMarkerForJavaElement(this.javaElt, markers, recursive);
        return forJavaElement;
    }

    @Nullable
    private static IPath getMatchingSourceRoot(@Nullable IPath srcPath, Map<IPath, IPath> outLocations) {
        if (srcPath == null) {
            return null;
        }
        Set<Map.Entry<IPath, IPath>> outEntries = outLocations.entrySet();
        IPath result = null;
        int maxSegments = 0;
        for (Map.Entry<IPath, IPath> entry : outEntries) {
            IPath srcRoot = entry.getKey();
            int firstSegments = srcPath.matchingFirstSegments(srcRoot);
            if (firstSegments <= maxSegments || firstSegments != srcRoot.segmentCount()) continue;
            maxSegments = firstSegments;
            result = srcRoot;
        }
        return result;
    }

    public String getName() {
        return this.resource != null ? this.resource.getName() : this.javaElt.getElementName();
    }

    @CheckForNull
    public IPath getPath() {
        IResource corespondingResource = this.getCorespondingResource();
        if (corespondingResource != null) {
            return corespondingResource.getLocation();
        }
        if (this.javaElt != null) {
            return this.javaElt.getPath();
        }
        return null;
    }

    public boolean isDirectory() {
        IResource corespondingResource = this.getCorespondingResource();
        if (corespondingResource != null) {
            return corespondingResource.getType() == 2 || corespondingResource.getType() == 4;
        }
        return false;
    }

    public boolean isFromArchive() {
        IPath path = this.getPath();
        if (path == null) {
            return false;
        }
        File file = path.toFile();
        if (file.isDirectory()) {
            return false;
        }
        return Archive.isArchiveFileName(file.getName());
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.javaElt == null ? 0 : this.javaElt.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WorkItem)) {
            return false;
        }
        WorkItem other = (WorkItem)obj;
        if (this.javaElt == null ? other.javaElt != null : !this.javaElt.equals(other.javaElt)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals((Object)other.resource));
    }
}

