/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.FindBugsJob;
import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.FindBugs2Eclipse;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.builder.ResourceUtils;
import de.tobject.findbugs.builder.WorkItem;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.plugin.eclipse.util.MutexSchedulingRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;

public class FindBugsBuilder
extends IncrementalProjectBuilder {
    public static boolean DEBUG;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Running FindBugs...");
        switch (kind) {
            case 6: {
                FindBugs2Eclipse.cleanClassClache(this.getProject());
                if (!FindbugsPlugin.getUserPreferences(this.getProject()).isRunAtFullBuild()) break;
                if (DEBUG) {
                    System.out.println("FULL BUILD");
                }
                this.doBuild(args, monitor, kind);
                break;
            }
            case 10: {
                if (DEBUG) {
                    System.out.println("INCREMENTAL BUILD");
                }
                this.doBuild(args, monitor, kind);
                break;
            }
            case 9: {
                if (DEBUG) {
                    System.out.println("AUTO BUILD");
                }
                this.doBuild(args, monitor, kind);
                break;
            }
            default: {
                FindbugsPlugin.getDefault().logWarning("UKNOWN BUILD kind" + kind);
                this.doBuild(args, monitor, kind);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        MarkerUtil.removeMarkers((IResource)this.getProject());
    }

    private void doBuild(Map<?, ?> args, IProgressMonitor monitor, int kind) throws CoreException {
        List<WorkItem> files;
        IProject project;
        boolean incremental = kind == 10 || kind == 9;
        IProject resource = project = this.getProject();
        if (incremental) {
            boolean configChanged;
            IResourceDelta resourceDelta = this.getDelta(project);
            boolean bl = configChanged = !this.isConfigUnchanged(resourceDelta);
            if (configChanged) {
                files = new ArrayList();
                files.add(new WorkItem((IResource)project));
            } else {
                IResource corespondingResource;
                files = ResourceUtils.collectIncremental(resourceDelta);
                if (files.size() == 1 && (corespondingResource = files.get(0).getCorespondingResource()) != null) {
                    resource = corespondingResource;
                }
            }
        } else {
            files = new ArrayList<WorkItem>();
            files.add(new WorkItem((IResource)project));
        }
        this.work((IResource)resource, files, monitor);
    }

    protected void work(IResource resource, List<WorkItem> resources, IProgressMonitor monitor) {
        IPreferenceStore store = FindbugsPlugin.getPluginPreferences(this.getProject());
        boolean runAsJob = store.getBoolean("runAnalysisAsExtraJob");
        StartedFromBuilderJob fbJob = new StartedFromBuilderJob("Finding bugs in " + resource.getName() + "...", resource, resources);
        if (runAsJob) {
            if (DEBUG) {
                FindbugsPlugin.log("cancelSimilarJobs");
            }
            FindBugsJob.cancelSimilarJobs(fbJob);
            if (DEBUG) {
                FindbugsPlugin.log("scheduleAsSystem");
            }
            fbJob.scheduleAsSystem();
            if (DEBUG) {
                FindbugsPlugin.log("done scheduleAsSystem");
            }
        } else {
            if (DEBUG) {
                FindbugsPlugin.log("running fbJob");
            }
            fbJob.run(monitor);
            if (DEBUG) {
                FindbugsPlugin.log("done fbJob");
            }
        }
    }

    private boolean isConfigUnchanged(IResourceDelta resourceDelta) {
        return resourceDelta != null && resourceDelta.findMember((IPath)new Path(".project")) == null && resourceDelta.findMember((IPath)new Path(".classpath")) == null && resourceDelta.findMember(FindbugsPlugin.DEPRECATED_PREFS_PATH) == null && resourceDelta.findMember(FindbugsPlugin.DEFAULT_PREFS_PATH) == null;
    }

    private static final class StartedFromBuilderJob
    extends FindBugsJob {
        private final List<WorkItem> resources;

        private StartedFromBuilderJob(String name, IResource resource, List<WorkItem> resources) {
            super(name, resource);
            this.resources = resources;
        }

        @Override
        protected boolean supportsMulticore() {
            return MutexSchedulingRule.MULTICORE;
        }

        @Override
        protected void runWithProgress(IProgressMonitor monitor) throws CoreException {
            FindBugsWorker worker = new FindBugsWorker(this.getResource(), monitor);
            worker.work(this.resources);
        }
    }
}

