/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindBugsJob;
import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.actions.FindBugsAction;
import edu.umd.cs.findbugs.SortedBugCollection;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveXmlAction
extends FindBugsAction {
    private static final String DIALOG_SETTINGS_SECTION = "SaveXMLDialogSettings";
    private static final String SAVE_XML_PATH_KEY = "SaveXMLPathSetting";

    @Override
    public void run(IAction action) {
        String fileName;
        if (!(this.selection instanceof IStructuredSelection) || this.selection.isEmpty()) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
        IProject project = this.getProject(structuredSelection);
        if (project == null) {
            return;
        }
        FileDialog fileDialog = this.createFileDialog(project);
        boolean validFileName = false;
        while ((fileName = this.openFileDialog(fileDialog)) != null) {
            validFileName = this.validateSelectedFileName(fileName);
            if (!validFileName) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warning", (String)(fileName + " is not a file or is not writable!"));
            } else if (!new File(fileName).exists() || MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Warning", (String)(fileName + " already exists. Override?"))) {
                this.getDialogSettings().put(SAVE_XML_PATH_KEY, fileName);
                this.work(project, fileName);
            }
            if (!validFileName) continue;
        }
    }

    protected String openFileDialog(FileDialog dialog) {
        return dialog.open();
    }

    private FileDialog createFileDialog(IProject project) {
        FileDialog fileDialog = new FileDialog(FindbugsPlugin.getShell(), 73728);
        fileDialog.setText("Select bug result xml for project: " + project.getName());
        String initialFileName = this.getDialogSettings().get(SAVE_XML_PATH_KEY);
        if (initialFileName != null && initialFileName.length() > 0) {
            File initialFile = new File(initialFileName);
            if (initialFile.exists()) {
                fileDialog.setFileName(initialFile.getName());
            }
            fileDialog.setFilterPath(initialFile.getParent());
        }
        return fileDialog;
    }

    private boolean validateSelectedFileName(String fileName) {
        if (fileName == null) {
            return false;
        }
        File file = new File(fileName);
        return !file.exists() || file.isFile() && file.canWrite();
    }

    @Override
    protected String getDialogSettingsId() {
        return DIALOG_SETTINGS_SECTION;
    }

    private void work(final IProject project, final String fileName) {
        FindBugsJob runFindBugs = new FindBugsJob("Saving FindBugs XML data to " + fileName + "...", (IResource)project){

            @Override
            protected void runWithProgress(IProgressMonitor monitor) throws CoreException {
                SortedBugCollection bugCollection = FindbugsPlugin.getBugCollection(project, monitor);
                try {
                    bugCollection.writeXML(fileName);
                }
                catch (IOException e) {
                    CoreException ex = new CoreException(FindbugsPlugin.createErrorStatus("Can't write FindBugs bug collection from project " + project + " to file " + fileName, e));
                    throw ex;
                }
            }
        };
        runFindBugs.setRule((ISchedulingRule)project);
        runFindBugs.scheduleInteractive();
    }
}

