/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2Core;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodsSourcePositionComparator;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class AddUnimplementedMethodsOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    private ASTNode fTypeNode;

    public AddUnimplementedMethodsOperation(ASTNode typeNode) {
        this.fTypeNode = typeNode;
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
        ListRewrite listRewrite;
        AnonymousClassDeclaration decl;
        IMethodBinding[] unimplementedMethods = this.getUnimplementedMethods(this.fTypeNode);
        if (unimplementedMethods.length == 0) {
            return;
        }
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(this.fTypeNode, cuRewrite.getImportRewrite());
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        ICompilationUnit unit = cuRewrite.getCu();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(unit.getJavaProject());
        if (this.fTypeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fTypeNode;
            listRewrite = rewrite.getListRewrite((ASTNode)decl, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            settings.createComments = false;
        } else if (this.fTypeNode instanceof AbstractTypeDeclaration) {
            decl = (AbstractTypeDeclaration)this.fTypeNode;
            listRewrite = rewrite.getListRewrite((ASTNode)decl, decl.getBodyDeclarationsProperty());
        } else if (this.fTypeNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)this.fTypeNode;
            AnonymousClassDeclaration anonymousClassDeclaration = enumConstantDeclaration.getAnonymousClassDeclaration();
            if (anonymousClassDeclaration == null) {
                anonymousClassDeclaration = rewrite.getAST().newAnonymousClassDeclaration();
                rewrite.set((ASTNode)enumConstantDeclaration, (StructuralPropertyDescriptor)EnumConstantDeclaration.ANONYMOUS_CLASS_DECLARATION_PROPERTY, (Object)anonymousClassDeclaration, this.createTextEditGroup(CorrectionMessages.AddUnimplementedMethodsOperation_AddMissingMethod_group, cuRewrite));
            }
            listRewrite = rewrite.getListRewrite((ASTNode)anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            settings.createComments = false;
        } else {
            Assert.isTrue((boolean)false, (String)"Unknown type node");
            return;
        }
        ImportRewrite imports = cuRewrite.getImportRewrite();
        IMethodBinding[] iMethodBindingArray = unimplementedMethods;
        int n = unimplementedMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding curr = iMethodBindingArray[n2];
            MethodDeclaration newMethodDecl = StubUtility2Core.createImplementationStubCore(unit, rewrite, imports, context, curr, curr.getDeclaringClass(), settings, false, this.fTypeNode, false);
            listRewrite.insertLast((ASTNode)newMethodDecl, this.createTextEditGroup(CorrectionMessages.AddUnimplementedMethodsOperation_AddMissingMethod_group, cuRewrite));
            ++n2;
        }
    }

    @Override
    public String getAdditionalInfo() {
        if (this.fTypeNode instanceof EnumDeclaration) {
            return CorrectionMessages.UnimplementedMethodsCorrectionProposal_enum_info;
        }
        IMethodBinding[] methodsToOverride = this.getMethodsToImplement();
        StringBuilder buf = new StringBuilder();
        buf.append("<b>");
        if (methodsToOverride.length == 1) {
            buf.append(CorrectionMessages.UnimplementedMethodsCorrectionProposal_info_singular);
        } else {
            buf.append(Messages.format(CorrectionMessages.UnimplementedMethodsCorrectionProposal_info_plural, String.valueOf(methodsToOverride.length)));
        }
        buf.append("</b><ul>");
        IMethodBinding[] iMethodBindingArray = methodsToOverride;
        int n = methodsToOverride.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding element = iMethodBindingArray[n2];
            buf.append("<li>");
            buf.append(BindingLabelProviderCore.getBindingLabel((IBinding)element, JavaElementLabelsCore.ALL_FULLY_QUALIFIED));
            buf.append("</li>");
            ++n2;
        }
        buf.append("</ul>");
        return buf.toString();
    }

    public IMethodBinding[] getMethodsToImplement() {
        return this.getUnimplementedMethods(this.fTypeNode);
    }

    private IMethodBinding[] getUnimplementedMethods(ASTNode typeNode) {
        AnonymousClassDeclaration decl;
        ITypeBinding binding = null;
        boolean implementAbstractsOfInput = false;
        if (typeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)typeNode;
            binding = decl.resolveBinding();
        } else if (typeNode instanceof AbstractTypeDeclaration) {
            decl = (AbstractTypeDeclaration)typeNode;
            binding = decl.resolveBinding();
        } else if (typeNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)typeNode;
            if (enumConstantDeclaration.getAnonymousClassDeclaration() != null) {
                binding = enumConstantDeclaration.getAnonymousClassDeclaration().resolveBinding();
            } else {
                IVariableBinding varBinding = enumConstantDeclaration.resolveVariable();
                if (varBinding != null) {
                    binding = varBinding.getDeclaringClass();
                    implementAbstractsOfInput = true;
                }
            }
        }
        if (binding == null) {
            return new IMethodBinding[0];
        }
        IMethodBinding[] unimplementedMethods = StubUtility2Core.getUnimplementedMethods(binding, implementAbstractsOfInput);
        Arrays.sort(unimplementedMethods, new MethodsSourcePositionComparator(binding));
        return unimplementedMethods;
    }
}

