/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.internal.Activator;
import org.eclipse.osee.framework.plugin.core.server.ClassServerPermissions;
import org.eclipse.osee.framework.plugin.core.server.ResourceFinder;

public class PathResourceFinder
extends ResourceFinder {
    private final HashSet<JarFile> jars = new HashSet(128);
    private final HashSet<String> dirs = new HashSet(128);
    private final HashMap<String, JarFile[]> map = new HashMap(128);
    private final boolean trees;
    private final ClassServerPermissions perm;
    private static final int NUMBER_OF_FILE_READ_ATTEMPTS = 20;

    public PathResourceFinder(String[] dirsToAdd, boolean trees) {
        this.trees = trees;
        this.perm = new ClassServerPermissions();
        if (dirsToAdd != null) {
            this.addPaths(dirsToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] find(String path) throws IOException {
        JarFile[] jfs;
        int i = path.indexOf(47);
        if (i > 0 && (jfs = this.map.get(path.substring(0, i))) != null) {
            String jpath = path.substring(i + 1);
            i = 0;
            while (i < jfs.length) {
                JarEntry je = jfs[i].getJarEntry(jpath);
                if (je != null) {
                    return this.getBytes(jfs[i].getInputStream(je), je.getSize());
                }
                ++i;
            }
        }
        jfs = this.jars;
        synchronized (this.jars) {
            for (JarFile jar : this.jars) {
                JarEntry je = jar.getJarEntry(path);
                if (je == null) continue;
                // ** MonitorExit[jfs] (shouldn't be in output)
                return this.getBytes(jar.getInputStream(je), je.getSize());
            }
            // ** MonitorExit[jfs] (shouldn't be in output)
            boolean exists = false;
            File f = null;
            HashSet<String> hashSet = this.dirs;
            synchronized (hashSet) {
                int j = 0;
                while (j < 20) {
                    for (String dirString : this.dirs) {
                        f = new File(String.valueOf(dirString) + File.separatorChar + path.replace('/', File.separatorChar));
                        if (!f.exists()) continue;
                        exists = true;
                        break;
                    }
                    if (exists) break;
                    try {
                        PathResourceFinder pathResourceFinder = this;
                        synchronized (pathResourceFinder) {
                            this.wait(1000L);
                        }
                        XConsoleLogger.err((String)String.format("trying to find :%s %d", path, j), (Object[])new Object[0]);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++j;
                }
            }
            if (exists && f != null && this.perm.implies(new FilePermission(f.getPath(), "read"))) {
                try {
                    return this.getBytes(new FileInputStream(f), f.length());
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaths(String[] paths) {
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            if (path.startsWith("file:\\")) {
                path = path.substring(6);
            }
            if (path.endsWith(".jar")) {
                try {
                    HashSet<JarFile> hashSet = this.jars;
                    synchronized (hashSet) {
                        this.jars.add(new JarFile(new File(path)));
                        break block17;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                File fdir;
                String[] files;
                block17: {
                    if (this.dirs.add(path)) {
                        this.perm.add(new FilePermission(String.valueOf(path) + File.separator + '-', "read"));
                    }
                }
                if (this.trees && (files = (fdir = new File(path)).list()) != null) {
                    try {
                        URL base = fdir.toURI().toURL();
                        int j = 0;
                        while (j < files.length) {
                            String jar = files[j];
                            if (jar.endsWith(".jar") || jar.endsWith(".zip")) {
                                ArrayList<JarFile> jfs = new ArrayList<JarFile>(10);
                                try {
                                    this.addJar(jar, jfs, base);
                                    this.map.put(jar.substring(0, jar.length() - 4), jfs.toArray(new JarFile[jfs.size()]));
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            ++j;
                        }
                    }
                    catch (MalformedURLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    private void addJar(String jar, ArrayList<JarFile> jfs, URL base) throws IOException {
        base = new URL(base, jar);
        jar = base.getFile().replace('/', File.separatorChar);
        int i = jfs.size();
        while (--i >= 0) {
            if (!jar.equals(jfs.get(i).getName())) continue;
            return;
        }
        JarFile jf = new JarFile(jar);
        jfs.add(jf);
        try {
            Manifest man = jf.getManifest();
            if (man == null) {
                return;
            }
            Attributes attrs = man.getMainAttributes();
            if (attrs == null) {
                return;
            }
            String val = attrs.getValue(Attributes.Name.CLASS_PATH);
            if (val == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(val);
            while (st.hasMoreTokens()) {
                this.addJar(st.nextToken(), jfs, base);
            }
        }
        catch (IOException ex) {
            jfs.remove(jf);
            jf.close();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getJarFile(String name) {
        File jarFileReturn = null;
        HashSet<JarFile> hashSet = this.jars;
        synchronized (hashSet) {
            for (JarFile jarFile : this.jars) {
                if (!jarFile.getName().endsWith(String.valueOf(File.separator) + name)) continue;
                jarFileReturn = new File(jarFile.getName());
                break;
            }
        }
        return jarFileReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJarFile(String name) {
        HashSet<JarFile> hashSet = this.jars;
        synchronized (hashSet) {
            Iterator<JarFile> it = this.jars.iterator();
            while (it.hasNext()) {
                JarFile jarFile = it.next();
                if (!jarFile.getName().endsWith(String.valueOf(File.separator) + name)) continue;
                try {
                    OseeLog.log(Activator.class, (Level)Level.INFO, (String)("removing JAR file " + name));
                    jarFile.close();
                }
                catch (IOException iOException) {}
                it.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        HashSet<JarFile> hashSet = this.jars;
        synchronized (hashSet) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)"disposing path resource finder's cached JAR files");
            for (JarFile jarFile : this.jars) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            this.jars.clear();
        }
    }
}

