/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class RendererUtil {
    private static IFolder workingFolder;
    private static IFolder compareFolder;
    private static IFolder previewFolder;
    private static final Random generator;
    private static final int FILENAME_LIMIT = 215;

    static {
        generator = new Random();
    }

    public static String toFileName(BranchToken branch) {
        String shortName = Strings.saferReplace((String)branch.getShortName(), (String)"[\\.\\/:\"*?<>|'\\\\]+", (String)"_");
        return RendererUtil.encode(shortName);
    }

    private static String encode(String name) {
        String toReturn = null;
        try {
            toReturn = URLEncoder.encode(name, "UTF-8");
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return toReturn;
    }

    private static String constructFilename(String mainName, String fileNamePrefix, String extension) {
        StringBuilder name = new StringBuilder(128);
        if (Strings.isValid((String)fileNamePrefix)) {
            name.append(fileNamePrefix);
            name.append("_");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        name.append(mainName);
        name.append("_");
        name.append(dateFormat.format(new Date()));
        name.append("-");
        name.append(generator.nextInt(99999) + 1);
        name.append(extension);
        return name.toString();
    }

    public static IFile getRenderFile(BranchToken branch, PresentationType presentationType, String pathPrefix, String mainName, String extension) {
        String subFolder = RendererUtil.toFileName(branch);
        String fileNamePrefix = null;
        if (Strings.isValid((String)pathPrefix)) {
            int index = pathPrefix.lastIndexOf("/");
            if (index != -1) {
                subFolder = pathPrefix.substring(0, index);
            }
            fileNamePrefix = pathPrefix.substring(index + 1);
            fileNamePrefix = fileNamePrefix.trim();
        }
        subFolder = subFolder.trim();
        String fileName = RendererUtil.constructFilename(mainName, fileNamePrefix, extension);
        return RendererUtil.getRenderFile(subFolder, fileName, presentationType);
    }

    private static IFile getRenderFile(String subFolder, String fileName, PresentationType presentationType) {
        try {
            IFolder baseFolder = RendererUtil.ensureRenderFolderExists(presentationType);
            IFolder renderFolder = baseFolder.getFolder(subFolder);
            if (!renderFolder.exists()) {
                renderFolder.create(true, true, null);
            }
            IFile file = renderFolder.getFile(fileName);
            return file;
        }
        catch (CoreException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static IFolder ensureRenderFolderExists(PresentationType presentationType) {
        IFolder toReturn = null;
        switch (presentationType) {
            case DIFF: 
            case MERGE: {
                toReturn = compareFolder = RendererUtil.getOrCreateFolder(compareFolder, ".compare");
                break;
            }
            case SPECIALIZED_EDIT: {
                toReturn = workingFolder = RendererUtil.getOrCreateFolder(workingFolder, ".working");
                break;
            }
            case PREVIEW: {
                toReturn = previewFolder = RendererUtil.getOrCreateFolder(previewFolder, ".preview");
                break;
            }
            default: {
                throw new OseeArgumentException("Unexpected presentation type: %s", new Object[]{presentationType});
            }
        }
        return toReturn;
    }

    private static IFolder getOrCreateFolder(IFolder folder, String name) {
        IFolder toCheck = folder;
        if (toCheck == null || !toCheck.exists()) {
            toCheck = OseeData.getFolder(name);
        }
        return toCheck;
    }

    public static boolean ensureFilenameLimit(IFile file) {
        String absPath;
        boolean withinLimit = true;
        if (Lib.isWindows() && (absPath = file.getLocation().toFile().getAbsolutePath()).length() > 215) {
            withinLimit = false;
        }
        return withinLimit;
    }
}

