/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeObject;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.exception.OseeTypeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.FullyNamed;
import org.eclipse.osee.framework.jdk.core.type.HasDescription;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;

public interface AttributeTypeToken
extends AttributeTypeId,
FullyNamed,
HasDescription,
NamedId {
    public static final AttributeTypeGeneric<?> SENTINEL = AttributeTypeToken.valueOf(Id.SENTINEL, "Sentinel");
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String TEXT_CALENDAR = "text/calendar";
    public static final String TEXT_URI_LIST = "text/uri-list";
    public static final String APPLICATION_MSWORD = "application/msword";
    public static final String MODEL_OSEE = "model/osee";
    public static final String IMAGE = "image/*";

    public String getMediaType();

    public String getFileExtension();

    public Set<DisplayHint> getDisplayHints();

    default public NamespaceToken getNamespace() {
        return NamespaceToken.SENTINEL;
    }

    default public TaggerTypeToken getTaggerType() {
        return TaggerTypeToken.SENTINEL;
    }

    default public boolean isTaggable() {
        return false;
    }

    default public boolean isString() {
        return false;
    }

    default public boolean isEnumerated() {
        return false;
    }

    default public boolean isBoolean() {
        return false;
    }

    default public boolean isDate() {
        return false;
    }

    default public boolean isInteger() {
        return false;
    }

    default public boolean isDouble() {
        return false;
    }

    default public boolean isLong() {
        return false;
    }

    default public boolean isArtifactId() {
        return false;
    }

    default public boolean isBranchId() {
        return false;
    }

    default public boolean isInputStream() {
        return false;
    }

    default public boolean isJavaObject() {
        return false;
    }

    public static AttributeTypeToken valueOf(String id) {
        return AttributeTypeToken.valueOf(Long.valueOf(id), "Sentinel");
    }

    public static AttributeTypeToken valueOf(int id, String name) {
        return AttributeTypeToken.valueOf(Long.valueOf(id), name, "");
    }

    public static AttributeTypeGeneric<?> valueOf(Long id, String name) {
        return AttributeTypeToken.valueOf(id, name, "");
    }

    public static @NonNull AttributeTypeGeneric<?> valueOf(Long id, String name, String description) {
        return new AttributeTypeObject(id, NamespaceToken.SENTINEL, name, "text/plain", description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeString createString(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType, String fileExtension) {
        return new AttributeTypeString(id, namespace, name, mediaType, description, taggerType, fileExtension, new DisplayHint[0]);
    }

    public static @NonNull AttributeTypeString createString(Long id, NamespaceToken namespace, String name, String mediaType, String description, String fileExtension) {
        return AttributeTypeToken.createString(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType), fileExtension);
    }

    public static TaggerTypeToken determineTaggerType(String mediaType) {
        switch (mediaType) {
            case "text/html": 
            case "application/msword": {
                return TaggerTypeToken.XmlTagger;
            }
            case "Sentinel": {
                return TaggerTypeToken.SENTINEL;
            }
        }
        return TaggerTypeToken.PlainTextTagger;
    }

    default public boolean isUri() {
        String mediaType = this.getMediaType();
        return mediaType.equals(TEXT_URI_LIST) || mediaType.equals(APPLICATION_MSWORD) || mediaType.equals(IMAGE) || mediaType.equals(APPLICATION_ZIP) || mediaType.equals("text/html") || mediaType.equals("application/octet-stream");
    }

    default public <T extends EnumToken> AttributeTypeEnum<T> toEnum() {
        if (this.isEnumerated()) {
            try {
                return (AttributeTypeEnum)this;
            }
            catch (Exception exception) {
                throw new OseeTypeDoesNotExist("Attribute type [%s] cannot be cast to an enum.", this.getName());
            }
        }
        throw new OseeTypeDoesNotExist("Attribute type [%s] is not an enum type.", this.getName());
    }

    default public boolean isSingleLine() {
        return this.getDisplayHints().contains((Object)DisplayHint.SingleLine);
    }

    default public boolean isMultiLine() {
        return this.getDisplayHints().contains((Object)DisplayHint.MultiLine);
    }

    default public boolean notEditable() {
        return this.getDisplayHints().contains((Object)DisplayHint.NoGeneralEdit);
    }

    default public boolean notRenderable() {
        return this.getDisplayHints().contains((Object)DisplayHint.NoGeneralRender);
    }
}

