/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal.osgi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.internal.osgi.JdbcServiceConfig;

public final class JdbcServiceConfigParser {
    public Map<String, JdbcServiceConfig> parse(String source) {
        LinkedHashMap<String, JdbcServiceConfig> toReturn = new LinkedHashMap<String, JdbcServiceConfig>();
        if (Strings.isValid((String)source)) {
            try {
                ObjectMapper OM = new ObjectMapper();
                OM.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                JsonNode jNode = OM.readTree(source);
                Iterator elements = jNode.elements();
                while (elements.hasNext()) {
                    JdbcServiceConfig newConfig = this.asConfig((JsonNode)elements.next());
                    if (newConfig.isEmpty()) continue;
                    this.checkId(newConfig);
                    JdbcServiceConfig oldConfig = toReturn.put(newConfig.getId(), newConfig);
                    this.checkUnique(oldConfig, newConfig);
                }
            }
            catch (IOException ex) {
                throw JdbcException.newJdbcException(ex, "Error parsing jdbc config [%s]", source);
            }
        }
        return toReturn;
    }

    private JdbcServiceConfig asConfig(JsonNode object) throws IOException {
        JdbcServiceConfig toReturn = new JdbcServiceConfig();
        ObjectMapper OM = new ObjectMapper();
        JsonNode newNode = OM.readTree(object.toString());
        Iterator fields = newNode.fieldNames();
        Iterator elements = newNode.elements();
        while (fields.hasNext()) {
            toReturn.put((String)fields.next(), ((JsonNode)elements.next()).asText());
        }
        return toReturn;
    }

    private void checkId(JdbcServiceConfig config) {
        String id = config.getId();
        if (!Strings.isValid((String)id)) {
            throw this.newError("id cannot be null or empty - config[%s]", config);
        }
    }

    private void checkUnique(JdbcServiceConfig oldConfig, JdbcServiceConfig newConfig) {
        if (oldConfig != null) {
            throw this.newError("duplicate service id detected - id[%s]", newConfig.getId());
        }
    }

    private RuntimeException newError(String msg, Object ... args) {
        return JdbcException.newJdbcException("Jdbc Service configuration error - " + msg, args);
    }
}

