/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.indexer.statistics;

import org.eclipse.osee.orcs.core.ds.IndexerData;
import org.eclipse.osee.orcs.core.internal.indexer.statistics.IndexerItemStatisticsImpl;
import org.eclipse.osee.orcs.statistics.IndexerItemStatistics;
import org.eclipse.osee.orcs.statistics.IndexerStatistics;

public class IndexerStatisticsImpl
implements Cloneable,
IndexerStatistics {
    public static final IndexerStatisticsImpl EMPTY_STATS = new IndexerStatisticsImpl();
    private static final IndexerItemStatisticsImpl DEFAULT_TASK_STATS = new IndexerItemStatisticsImpl(-1L, -1, -1L);
    private long averageQueryIdWaitTime;
    private long averageAttributeProcessingTime;
    private long averageQueryIdProcessingTime;
    private long totalTags;
    private int totalAttributesProcessed;
    private int totalQueryIdsProcessed;
    private long totalQueryIdWaitTime;
    private long totalQueryIdProcessingTime;
    private long totalAttributeProcessingTime;
    private long longestQueryIdWaitTime;
    private long longestQueryIdProcessingTime;
    private IndexerItemStatisticsImpl longestTask;
    private IndexerItemStatisticsImpl mostTags;
    private IndexerData indexerData;

    public IndexerStatisticsImpl() {
        this.clear();
    }

    public void clear() {
        this.averageQueryIdWaitTime = 0L;
        this.totalTags = 0L;
        this.averageAttributeProcessingTime = 0L;
        this.averageQueryIdProcessingTime = 0L;
        this.totalAttributesProcessed = 0;
        this.totalQueryIdsProcessed = 0;
        this.totalQueryIdWaitTime = 0L;
        this.totalAttributeProcessingTime = 0L;
        this.totalQueryIdProcessingTime = 0L;
        this.longestQueryIdWaitTime = 0L;
        this.longestQueryIdProcessingTime = 0L;
        this.longestTask = DEFAULT_TASK_STATS;
        this.mostTags = DEFAULT_TASK_STATS;
    }

    public long getLongestQueryIdWaitTime() {
        return this.longestQueryIdWaitTime;
    }

    public long getLongestQueryIdProcessingTime() {
        return this.longestQueryIdProcessingTime;
    }

    public long getAverageQueryIdWaitTime() {
        return this.averageQueryIdWaitTime;
    }

    public int getTotalQueryIdsProcessed() {
        return this.totalQueryIdsProcessed;
    }

    public long getAverageQueryIdProcessingTime() {
        return this.averageQueryIdProcessingTime;
    }

    public long getAverageAttributeProcessingTime() {
        return this.averageAttributeProcessingTime;
    }

    public long getTotalTags() {
        return this.totalTags;
    }

    public int getTotalAttributesProcessed() {
        return this.totalAttributesProcessed;
    }

    public long getLongestAttributeProcessingTime() {
        return this.longestTask.getProcessingTime();
    }

    public IndexerItemStatistics getLongestTask() {
        return this.longestTask;
    }

    public IndexerItemStatistics getMostTagsTask() {
        return this.mostTags;
    }

    public int getWorkersInQueue() {
        return this.indexerData != null ? this.indexerData.getWorkersInQueue() : -1;
    }

    public long getTagsInSystem() {
        return this.indexerData != null ? this.indexerData.getTotalTags() : -1L;
    }

    public long getTotalQueryIdsInQueue() {
        return this.indexerData != null ? this.indexerData.getTotalItemsInQueue() : -1L;
    }

    protected IndexerStatistics clone() {
        IndexerStatisticsImpl other = new IndexerStatisticsImpl();
        other.averageAttributeProcessingTime = this.averageAttributeProcessingTime;
        other.averageQueryIdProcessingTime = this.averageQueryIdProcessingTime;
        other.averageQueryIdWaitTime = this.averageQueryIdWaitTime;
        other.totalTags = this.totalTags;
        other.totalAttributesProcessed = this.totalAttributesProcessed;
        other.totalQueryIdsProcessed = this.totalQueryIdsProcessed;
        other.totalAttributeProcessingTime = this.totalAttributeProcessingTime;
        other.totalQueryIdProcessingTime = this.totalQueryIdProcessingTime;
        other.totalQueryIdWaitTime = this.totalQueryIdWaitTime;
        other.longestQueryIdWaitTime = this.longestQueryIdWaitTime;
        other.longestQueryIdProcessingTime = this.longestQueryIdProcessingTime;
        other.longestTask = this.longestTask.clone();
        other.mostTags = this.mostTags.clone();
        other.setIndexerData(this.indexerData);
        return other;
    }

    public void setIndexerData(IndexerData indexerData) {
        this.indexerData = indexerData;
    }

    public void addIndexerItem(int queryId, long gammaId, int totalTags, long processingTime) {
        this.totalTags += (long)totalTags;
        ++this.totalAttributesProcessed;
        this.totalAttributeProcessingTime += processingTime;
        this.averageAttributeProcessingTime = this.totalAttributeProcessingTime / (long)this.totalAttributesProcessed;
        IndexerItemStatisticsImpl newTask = new IndexerItemStatisticsImpl(gammaId, totalTags, processingTime);
        if (newTask.getProcessingTime() > this.longestTask.getProcessingTime()) {
            this.longestTask = newTask;
        }
        if (newTask.getTotalTags() > this.mostTags.getTotalTags()) {
            this.mostTags = newTask;
        }
    }

    public void addIndexerTask(int queryId, long waitTime, long processingTime) {
        ++this.totalQueryIdsProcessed;
        this.totalQueryIdWaitTime += waitTime;
        this.totalQueryIdProcessingTime += processingTime;
        this.averageQueryIdWaitTime = this.totalQueryIdWaitTime / (long)this.totalQueryIdsProcessed;
        this.averageQueryIdProcessingTime = this.totalQueryIdProcessingTime / (long)this.totalQueryIdsProcessed;
        this.longestQueryIdProcessingTime = Math.max(this.longestQueryIdProcessingTime, processingTime);
        this.longestQueryIdWaitTime = Math.max(this.longestQueryIdWaitTime, waitTime);
    }
}

