/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.event;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.event.AbstractTopicEvent;
import org.eclipse.osee.framework.core.event.EventType;
import org.eclipse.osee.framework.core.event.FrameworkEvent;
import org.eclipse.osee.framework.core.event.HasNetworkSender;
import org.eclipse.osee.framework.core.event.NetworkSender;

public class TopicEvent
implements FrameworkEvent,
HasNetworkSender {
    EventType eventType;
    private String topic;
    private final Map<String, String> properties;
    private NetworkSender networkSender;
    private TransactionId transaction;

    public TopicEvent(String topic) {
        this.topic = topic;
        this.properties = new HashMap<String, String>();
    }

    public TopicEvent(AbstractTopicEvent topic, String key, String value) {
        this(topic.getTopic(), key, value, topic.getTransaction(), topic.getEventType());
    }

    public TopicEvent(String topic, String key, String value, TransactionId transaction, EventType eventType) {
        this(topic);
        this.transaction = transaction;
        this.eventType = eventType;
        this.properties.put(key, value);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public NetworkSender getNetworkSender() {
        return this.networkSender;
    }

    @Override
    public void setNetworkSender(NetworkSender networkSender) {
        this.networkSender = networkSender;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public TransactionId getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionId transaction) {
        this.transaction = transaction;
    }

    public String toString() {
        return "TopicEvnt [type=" + (Object)((Object)this.eventType) + ", topic=" + this.topic + ",\nprops=" + this.properties + ", tx=" + this.transaction + ", sender=" + this.networkSender + "]";
    }
}

