/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.UserToken;

public class UserTokenSerializer
extends StdScalarSerializer<UserToken> {
    public UserTokenSerializer() {
        super(UserToken.class);
    }

    public void serialize(UserToken userToken, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        jgen.writeStringField("id", userToken.getIdString());
        jgen.writeStringField("name", userToken.getName());
        jgen.writeStringField("userId", userToken.getUserId());
        jgen.writeBooleanField("active", userToken.isActive());
        jgen.writeStringField("email", userToken.getEmail());
        jgen.writeArrayFieldStart("loginIds");
        for (String loginId : userToken.getLoginIds()) {
            jgen.writeString(loginId);
        }
        jgen.writeEndArray();
        jgen.writeArrayFieldStart("roles");
        for (ArtifactToken role : userToken.getRoles()) {
            jgen.writeStartObject();
            jgen.writeStringField("id", role.getIdString());
            jgen.writeStringField("name", role.getName());
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }
}

