/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class TransactionBuilderMessageReader
implements MessageBodyReader<TransactionBuilder> {
    private final OrcsApi orcsApi;
    private final TransactionFactory txFactory;
    private final JaxRsApi jaxRsApi;
    private final OrcsTokenService tokenService;
    private final QueryFactory query;

    public TransactionBuilderMessageReader(OrcsApi orcsApi) {
        this.txFactory = orcsApi.getTransactionFactory();
        this.jaxRsApi = orcsApi.jaxRsApi();
        this.orcsApi = orcsApi;
        this.tokenService = orcsApi.tokenService();
        this.query = orcsApi.getQueryFactory();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == TransactionBuilder.class;
    }

    public TransactionBuilder readFrom(Class<TransactionBuilder> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        JsonNode readTree = this.jaxRsApi.readTree(Lib.inputStreamToString((InputStream)entityStream));
        BranchId branch = BranchId.valueOf((Long)readTree.get("branch").asLong());
        HashMap<String, ArtifactToken> artifactsByName = new HashMap<String, ArtifactToken>();
        String txComment = readTree.get("txComment").asText();
        if (Strings.isInValid((String)txComment)) {
            txComment = "create transaction REST call";
        }
        TransactionBuilder tx = this.txFactory.createTransaction(branch, (UserId)this.orcsApi.userService().getUser(), txComment);
        this.createArtifacts(readTree, artifactsByName, tx);
        this.modifyArtifacts(readTree, artifactsByName, tx);
        this.deleteArtifacts(readTree, artifactsByName, tx);
        return tx;
    }

    private void createArtifacts(JsonNode root, Map<String, ArtifactToken> artifactsByName, TransactionBuilder tx) {
        if (root.has("createArtifacts")) {
            for (JsonNode artifactJson : root.get("createArtifacts")) {
                ApplicabilityId appId = artifactJson.has("applicabilityId") ? ApplicabilityId.valueOf((Long)artifactJson.get("applicabilityId").asLong()) : ApplicabilityId.BASE;
                ArtifactTypeToken artifactType = this.getArtifactType(artifactJson);
                ArtifactToken artifact = tx.createArtifact(artifactType, artifactJson.get("name").asText(), appId);
                artifactsByName.put(artifact.getName(), artifact);
                this.readAttributes(tx, artifactJson, artifact, "attributes");
                this.readrelations(tx, artifactsByName, artifactJson, artifact);
            }
        }
    }

    private void modifyArtifacts(JsonNode root, Map<String, ArtifactToken> artifactsByName, TransactionBuilder tx) {
        if (root.has("modifyArtifacts")) {
            for (JsonNode artifactJson : root.get("modifyArtifacts")) {
                ArtifactToken artifact = this.query.fromBranch(tx.getBranch()).andUuid(artifactJson.get("id").asLong()).asArtifactToken();
                artifactsByName.put(artifact.getName(), artifact);
                if (artifactJson.has("applicabilityId")) {
                    tx.setApplicability((ArtifactId)artifact, ApplicabilityId.valueOf((Long)artifactJson.get("applicabilityId").asLong()));
                }
                this.readAttributes(tx, artifactJson, artifact, "setAttributes");
                this.addAttributes(tx, artifactJson, artifact, "addAttributes");
                this.deleteAttributes(tx, artifactJson, artifact, "deleteAttributes");
            }
        }
    }

    private void deleteArtifacts(JsonNode root, Map<String, ArtifactToken> artifactsByName, TransactionBuilder tx) {
        if (root.has("deleteArtifacts")) {
            for (JsonNode artifactId : root.get("deleteArtifacts")) {
                tx.deleteArtifact(ArtifactId.valueOf((Long)artifactId.asLong()));
            }
        }
    }

    private void readAttributes(TransactionBuilder tx, JsonNode artifactJson, ArtifactToken artifact, String attributesNodeName) {
        if (artifactJson.has(attributesNodeName)) {
            Iterator attributes = artifactJson.get(attributesNodeName).fields();
            while (attributes.hasNext()) {
                Map.Entry attribute = (Map.Entry)attributes.next();
                AttributeTypeGeneric<?> attributeType = this.getAttributeType((String)attribute.getKey());
                JsonNode value = (JsonNode)attribute.getValue();
                if (value.isArray()) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (JsonNode attrValue : value) {
                        values.add(attrValue.asText());
                    }
                    tx.setAttributesFromStrings((ArtifactId)artifact, attributeType, values);
                    continue;
                }
                tx.setSoleAttributeFromString((ArtifactId)artifact, attributeType, value.asText());
            }
        }
    }

    private void addAttributes(TransactionBuilder tx, JsonNode artifactJson, ArtifactToken artifact, String attributesNodeName) {
        if (artifactJson.has(attributesNodeName)) {
            Iterator attributes = artifactJson.get(attributesNodeName).fields();
            while (attributes.hasNext()) {
                Map.Entry attribute = (Map.Entry)attributes.next();
                AttributeTypeGeneric<?> attributeType = this.getAttributeType((String)attribute.getKey());
                JsonNode value = (JsonNode)attribute.getValue();
                if (value.isArray()) {
                    for (JsonNode attrValue : value) {
                        tx.createAttribute((ArtifactId)artifact, attributeType, (Object)attrValue);
                    }
                    continue;
                }
                tx.createAttribute((ArtifactId)artifact, attributeType, (Object)value.asText());
            }
        }
    }

    private void deleteAttributes(TransactionBuilder tx, JsonNode artifactJson, ArtifactToken artifact, String attributesNodeName) {
        if (artifactJson.has(attributesNodeName)) {
            for (JsonNode attributeTypeString : artifactJson.get(attributesNodeName)) {
                tx.deleteAttributes((ArtifactId)artifact, this.getAttributeType(attributeTypeString.asText()));
            }
        }
    }

    private void readrelations(TransactionBuilder tx, Map<String, ArtifactToken> artifactsByName, JsonNode artifactJson, ArtifactToken artifact) {
        if (artifactJson.has("relations")) {
            Iterator relations = artifactJson.get("relations").fields();
            while (relations.hasNext()) {
                Map.Entry relation = (Map.Entry)relations.next();
                RelationTypeToken relationType = this.getRelationType((String)relation.getKey());
                JsonNode relationNode = (JsonNode)relation.getValue();
                if (relationNode.isTextual() || relationNode.isArray()) {
                    this.relate(tx, artifactsByName, relationNode, relationType, artifact, RelationSide.SIDE_A, "");
                    continue;
                }
                if (relationNode.isObject()) {
                    String rationale;
                    String string = rationale = relationNode.has("rationale") ? relationNode.get("rationale").asText() : "";
                    if (relationNode.has("sideA")) {
                        this.relate(tx, artifactsByName, relationNode.get("sideA"), relationType, artifact, RelationSide.SIDE_B, rationale);
                    }
                    if (!relationNode.has("sideB")) continue;
                    this.relate(tx, artifactsByName, relationNode.get("sideB"), relationType, artifact, RelationSide.SIDE_A, rationale);
                    continue;
                }
                throw new OseeStateException("Json Node of unexpected type %s", new Object[]{relationNode.getNodeType()});
            }
        }
    }

    private void relate(TransactionBuilder tx, Map<String, ArtifactToken> artifactsByName, JsonNode relations, RelationTypeToken relationType, ArtifactToken artifact, RelationSide side, String rationale) {
        if (relations.isTextual()) {
            ArtifactToken otherArtifact = this.getArtifactByName(tx, artifactsByName, relations.asText());
            this.relate(tx, relationType, artifact, side, rationale, otherArtifact);
        } else if (relations.isArray()) {
            for (JsonNode name : relations) {
                ArtifactToken otherArtifact = this.getArtifactByName(tx, artifactsByName, name.asText());
                this.relate(tx, relationType, artifact, side, rationale, otherArtifact);
            }
        } else {
            throw new OseeStateException("Json Node of unexpected type %s", new Object[]{relations.getNodeType()});
        }
    }

    private void relate(TransactionBuilder tx, RelationTypeToken relationType, ArtifactToken artifact, RelationSide side, String rationale, ArtifactToken otherArtifact) {
        if (side.isSideA()) {
            tx.relate((ArtifactId)artifact, relationType, (ArtifactId)otherArtifact, rationale);
        } else {
            tx.relate((ArtifactId)otherArtifact, relationType, (ArtifactId)artifact, rationale);
        }
    }

    private ArtifactToken getArtifactByName(TransactionBuilder tx, Map<String, ArtifactToken> artifactsByName, String name) {
        ArtifactToken artifact = artifactsByName.get(name);
        if (artifact != null) {
            return artifact;
        }
        return this.query.fromBranch(tx.getBranch()).andNameEquals(name).asArtifactToken();
    }

    private ArtifactTypeToken getArtifactType(JsonNode artifactJson) {
        JsonNode typeNode = artifactJson.get("type");
        if (typeNode == null || Strings.isInValid((String)typeNode.asText())) {
            throw new OseeArgumentException("The artifact type must be specified", new Object[0]);
        }
        String typeString = typeNode.asText();
        if (Strings.isNumeric((String)typeString)) {
            return this.tokenService.getArtifactType(Long.valueOf(typeString));
        }
        return this.tokenService.getArtifactType(typeString);
    }

    private AttributeTypeGeneric<?> getAttributeType(String typeString) {
        if (Strings.isInValid((String)typeString)) {
            throw new OseeArgumentException("The attribute type must be specified", new Object[0]);
        }
        if (Strings.isNumeric((String)typeString)) {
            return this.tokenService.getAttributeType(Long.valueOf(typeString));
        }
        return this.tokenService.getAttributeType(typeString);
    }

    private RelationTypeToken getRelationType(String typeString) {
        if (Strings.isInValid((String)typeString)) {
            throw new OseeArgumentException("The relation type must be specified", new Object[0]);
        }
        if (Strings.isNumeric((String)typeString)) {
            return this.tokenService.getRelationType(Long.valueOf(typeString));
        }
        return this.tokenService.getRelationType(typeString);
    }
}

