/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.InterfaceSubMessageEndpoint;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;

public class InterfaceSubMessageEndpointImpl
implements InterfaceSubMessageEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId messageId;
    private final InterfaceSubMessageApi subMessageApi;

    public InterfaceSubMessageEndpointImpl(BranchId branch, UserId account, ArtifactId messageId2, InterfaceSubMessageApi interfaceSubMessageApi) {
        this.account = account;
        this.branch = branch;
        this.messageId = messageId2;
        this.subMessageApi = interfaceSubMessageApi;
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllSubMessages() {
        try {
            return this.subMessageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, this.messageId, InterfaceSubMessageToken.class);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public XResultData createNewSubMessage(InterfaceSubMessageToken token) {
        XResultData createResults = this.subMessageApi.getInserter().addArtifact(token, this.account, this.branch);
        createResults.merge(this.subMessageApi.getInserter().relateArtifact(ArtifactId.valueOf((String)((String)createResults.getIds().get(0))), this.messageId, (RelationTypeToken)CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage, this.branch, this.account));
        return createResults;
    }

    @Override
    public XResultData updateSubMessage(InterfaceSubMessageToken token) {
        return this.subMessageApi.getInserter().replaceArtifact(token, this.account, this.branch);
    }

    @Override
    public XResultData patchSubMessage(InterfaceSubMessageToken token) {
        return this.subMessageApi.getInserter().patchArtifact(token, this.account, this.branch);
    }

    @Override
    public InterfaceSubMessageToken getSubMessage(ArtifactId subMessageId) {
        try {
            return this.subMessageApi.getAccessor().get(this.branch, subMessageId, InterfaceSubMessageToken.class);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public XResultData relateSubMessage(ArtifactId subMessageId) {
        return this.subMessageApi.getInserter().relateArtifact(subMessageId, this.messageId, (RelationTypeToken)CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage, this.branch, this.account);
    }

    @Override
    public XResultData removeSubMessage(ArtifactId subMessageId) {
        return this.subMessageApi.getInserter().unrelateArtifact(subMessageId, this.messageId, (RelationTypeToken)CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage, this.branch, this.account);
    }
}

