/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.mim.InterfaceConnectionEndpoint;
import org.eclipse.osee.mim.InterfaceConnectionModificationEndpoint;
import org.eclipse.osee.mim.InterfaceElementEndpoint;
import org.eclipse.osee.mim.InterfaceElementSearchEndpoint;
import org.eclipse.osee.mim.InterfaceGraphEndpoint;
import org.eclipse.osee.mim.InterfaceMessageEndpoint;
import org.eclipse.osee.mim.InterfaceMessageFilterEndpoint;
import org.eclipse.osee.mim.InterfaceNodeEndpoint;
import org.eclipse.osee.mim.InterfaceStructureEndpoint;
import org.eclipse.osee.mim.InterfaceStructureFilterEndpoint;
import org.eclipse.osee.mim.InterfaceStructureSearchEndpoint;
import org.eclipse.osee.mim.InterfaceSubMessageEndpoint;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.PlatformTypesEndpoint;
import org.eclipse.osee.mim.PlatformTypesFilterEndpoint;
import org.eclipse.osee.mim.internal.InterfaceConnectionEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceConnectionModificationEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceElementEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceElementSearchEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceGraphEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceMessageEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceMessageFilterEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceNodeEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceStructureEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceStructureFilterEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceStructureSearchEndpointImpl;
import org.eclipse.osee.mim.internal.InterfaceSubMessageEndpointImpl;
import org.eclipse.osee.mim.internal.PlatformTypesEndpointImpl;
import org.eclipse.osee.mim.internal.PlatformTypesFilterEndpointImpl;

@Path(value="branch")
public class BranchAccessor {
    private final MimApi mimApi;

    public BranchAccessor(MimApi mimApi) {
        this.mimApi = mimApi;
    }

    @Path(value="{branch}/types")
    @Produces(value={"application/json"})
    public PlatformTypesEndpoint getPlatformTypes(@PathParam(value="branch") BranchId branch, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new PlatformTypesEndpointImpl(branch, accountId, this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/types/filter")
    @Produces(value={"application/json"})
    public PlatformTypesFilterEndpoint getPlatformTypesFilter(@PathParam(value="branch") BranchId branch, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new PlatformTypesFilterEndpointImpl(branch, accountId, this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages")
    @Produces(value={"application/json"})
    public InterfaceMessageEndpoint getMessageEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceMessageEndpointImpl(branch, connectionId, accountId, this.mimApi.getInterfaceMessageApi(), this.mimApi.getInterfaceSubMessageApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/filter")
    @Produces(value={"application/json"})
    public InterfaceMessageFilterEndpoint getMessageFilterEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceMessageFilterEndpointImpl(branch, connectionId, accountId, this.mimApi.getInterfaceMessageApi(), this.mimApi.getInterfaceSubMessageApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/{messageId}/submessages")
    @Produces(value={"application/json"})
    public InterfaceSubMessageEndpoint getSubMessageEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @PathParam(value="messageId") ArtifactId messageId, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceSubMessageEndpointImpl(branch, accountId, messageId, this.mimApi.getInterfaceSubMessageApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/{messageId}/submessages/{submessageId}/structures")
    @Produces(value={"application/json"})
    public InterfaceStructureEndpoint getStructureEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @PathParam(value="messageId") ArtifactId messageId, @PathParam(value="submessageId") ArtifactId subMessageId, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceStructureEndpointImpl(branch, accountId, messageId, subMessageId, this.mimApi.getInterfaceStructureApi(), this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfaceElementArrayApi(), this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/{messageId}/submessages/{submessageId}/structures/filter")
    @Produces(value={"application/json"})
    public InterfaceStructureFilterEndpoint getStructureFilterEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @PathParam(value="messageId") ArtifactId messageId, @PathParam(value="submessageId") ArtifactId subMessageId, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceStructureFilterEndpointImpl(branch, accountId, messageId, subMessageId, this.mimApi.getInterfaceStructureApi(), this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfaceElementArrayApi(), this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/connections/{connectionId}/messages/{messageId}/submessages/{submessageId}/structures/{structureId}/elements")
    @Produces(value={"application/json"})
    public InterfaceElementEndpoint getElementEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="connectionId") ArtifactId connectionId, @PathParam(value="messageId") ArtifactId messageId, @PathParam(value="submessageId") ArtifactId subMessageId, @PathParam(value="structureId") ArtifactId structureId, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceElementEndpointImpl(branch, accountId, messageId, subMessageId, structureId, this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfaceElementArrayApi(), this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/elements")
    @Produces(value={"application/json"})
    public InterfaceElementSearchEndpoint getElementSearchEndpoint(@PathParam(value="branch") BranchId branch, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceElementSearchEndpointImpl(branch, accountId, this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfaceElementArrayApi(), this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/structures")
    @Produces(value={"application/json"})
    public InterfaceStructureSearchEndpoint getStructureSearchEndpoint(@PathParam(value="branch") BranchId branch, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceStructureSearchEndpointImpl(branch, accountId, this.mimApi.getInterfaceStructureApi(), this.mimApi.getInterfaceElementApi(), this.mimApi.getInterfaceElementArrayApi(), this.mimApi.getInterfacePlatformTypeApi());
    }

    @Path(value="{branch}/graph")
    @Produces(value={"application/json"})
    public InterfaceGraphEndpoint getGraphEndpoint(@PathParam(value="branch") BranchId branch, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceGraphEndpointImpl(branch, accountId, this.mimApi.getInterfaceNodeViewApi(), this.mimApi.getInterfaceConnectionViewApi());
    }

    @Path(value="{branch}/nodes")
    @Produces(value={"application/json"})
    public InterfaceNodeEndpoint getNodeEndpoint(@PathParam(value="branch") BranchId branch, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceNodeEndpointImpl(branch, accountId, this.mimApi.getInterfaceNodeViewApi(), this.mimApi.getInterfaceConnectionViewApi());
    }

    @Path(value="{branch}/connections")
    @Produces(value={"application/json"})
    public InterfaceConnectionEndpoint getConnectionEndpoint(@PathParam(value="branch") BranchId branch, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceConnectionEndpointImpl(branch, accountId, this.mimApi.getInterfaceNodeViewApi(), this.mimApi.getInterfaceConnectionViewApi());
    }

    @Path(value="{branch}/nodes/{nodeId}/connections")
    @Produces(value={"application/json"})
    public InterfaceConnectionModificationEndpoint getConnectionModificationEndpoint(@PathParam(value="branch") BranchId branch, @PathParam(value="nodeId") ArtifactId nodeId, @HeaderParam(value="osee.account.id") UserId accountId) {
        return new InterfaceConnectionModificationEndpointImpl(branch, accountId, nodeId, this.mimApi.getInterfaceNodeViewApi(), this.mimApi.getInterfaceConnectionViewApi());
    }
}

