/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api;

import java.util.Comparator;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public final class ParagraphNumberComparator
implements Comparator<ArtifactReadable> {
    private final ActivityLog activityLog;

    public ParagraphNumberComparator(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    @Override
    public int compare(ArtifactReadable art1, ArtifactReadable art2) {
        try {
            int size;
            int toReturn = 0;
            String paragraph1 = (String)art1.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)"");
            String paragraph2 = (String)art2.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)"");
            int[] set1 = this.getParagraphIndices(paragraph1);
            int[] set2 = this.getParagraphIndices(paragraph2);
            int length1 = set1.length;
            int length2 = set2.length;
            int n = size = length1 < length2 ? length1 : length2;
            if (size == 0 && length1 != length2) {
                toReturn = length1 < length2 ? -1 : 1;
            } else {
                int index = 0;
                while (index < size) {
                    toReturn = Integer.compare(set1[index], set2[index]);
                    if (toReturn != 0) break;
                    ++index;
                }
            }
            return toReturn;
        }
        catch (Exception ex) {
            this.activityLog.createThrowableEntry(CoreActivityTypes.OSEE_ERROR, (Throwable)ex);
            return 1;
        }
    }

    private int[] getParagraphIndices(String paragraph) {
        int[] paragraphs;
        if (Strings.isValid((String)paragraph)) {
            String[] values = paragraph.split("\\.");
            paragraphs = new int[values.length];
            int index = 0;
            while (index < values.length) {
                paragraphs[index] = Integer.parseInt(values[index].replace("-", ""));
                ++index;
            }
        } else {
            paragraphs = new int[]{};
        }
        return paragraphs;
    }
}

