/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class VariablePattern {
    private final String pattern;
    private final String indexedPattern;
    private final List<Variable> variables;

    private VariablePattern(String pattern, String indexedPattern, List<Variable> variables) {
        this.pattern = pattern;
        this.indexedPattern = indexedPattern;
        this.variables = variables;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getIndexedPattern() {
        return this.indexedPattern;
    }

    public List<String> getVariableNames() {
        ArrayList<String> toReturn = new ArrayList<String>(this.variables.size());
        for (Variable variable : this.variables) {
            toReturn.add(variable.getName());
        }
        return toReturn;
    }

    public String[] getVariableValues(Map<String, String> params) {
        String[] toReturn = new String[this.variables.size()];
        int index = 0;
        while (index < toReturn.length) {
            StringBuilder builder = new StringBuilder();
            Variable variable = this.variables.get(index);
            variable.format(builder, params);
            toReturn[index] = builder.toString();
            ++index;
        }
        return toReturn;
    }

    public String expandVariables(Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        for (Variable variable : this.variables) {
            variable.format(builder, params);
        }
        return builder.toString();
    }

    public String toString() {
        return this.getPattern();
    }

    public static VariablePattern newPattern(String pattern) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        StringBuilder builder = new StringBuilder();
        int size = pattern.length();
        int index = 0;
        while (index < size) {
            int varNameStart;
            int end;
            int start = pattern.indexOf("${", index);
            if (start < 0 || (end = pattern.indexOf("}", varNameStart = start + 2)) < 0) break;
            String variableString = pattern.substring(varNameStart, end);
            int varIndex = variables.size();
            variables.add(VariablePattern.newVariable(variableString));
            String constantString = pattern.substring(index, start);
            builder.append(constantString);
            builder.append("{");
            builder.append(varIndex);
            builder.append("}");
            index = end + 1;
        }
        if (index < size) {
            builder.append(pattern.substring(index));
        }
        String indexedPattern = builder.toString();
        return new VariablePattern(pattern, indexedPattern, variables);
    }

    private static Variable newVariable(String variableString) {
        return new Variable(variableString);
    }

    private static class Variable {
        private final String name;

        public Variable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void format(StringBuilder builder, Map<String, String> parameters) {
            String value = parameters.get(this.name);
            builder.append(value != null ? value : "");
        }
    }
}

