/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer.coverage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoApiConfiguration;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DispoSetCopier;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.vcast.VCastClient;
import org.eclipse.osee.vcast.VCastDataStore;
import org.eclipse.osee.vcast.VCastLisFileParser;
import org.eclipse.osee.vcast.VCastValidateDatFileSyntax;
import org.eclipse.osee.vcast.model.VCastFunction;
import org.eclipse.osee.vcast.model.VCastInstrumentedFile;
import org.eclipse.osee.vcast.model.VCastResult;
import org.eclipse.osee.vcast.model.VCastSourceFileJoin;
import org.eclipse.osee.vcast.model.VCastStatementCoverage;

public class LisFileParser
implements DispoImporterApi {
    private static final String RESULTS = "results";
    private static final String IMPORTED_RESULTS = "IMPORTED_RESULTS";
    private static final String LOG = "\\s*(log).*";
    private static final String EXIT_WHEN = "\\s*\\( \\)\\s*\\( \\)\\s*(EXIT WHEN).*";
    private static final String WHEN_FOR = "\\s*\\( \\)\\s*(WHEN|FOR).*";
    private static final String WHEN_CASE = "(.*\\bWHEN\\b\\s*[^:]*$)";
    private static final String CASE_STATEMENT = "(.*(\\bCASE|case|default|\\s+.+[:].*))";
    private static final String WHILE_ONE = "(.*\\bWHILE|while\\s*\\(1\\).*)";
    private final DispoDataFactory dataFactory;
    private static final Pattern fileMethod5LineNumberPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+([0-9]+)");
    private static final Pattern fileMethod3LineNumberPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)");
    private static final Pattern fileMethod4LineNumberPlusTokenPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+(T|F)");
    private final Map<String, DispoItemData> datIdToItem = new HashMap<String, DispoItemData>();
    private final Set<String> datIdsCoveredByException = new HashSet<String>();
    private final Set<String> alreadyUsedDatIds = new HashSet<String>();
    private final Set<String> alreadyUsedFileNames = new HashSet<String>();
    private final DispoConnector dispoConnector;
    private final DispoApiConfiguration config;
    private String vCastDir;

    public LisFileParser(Log logger, DispoDataFactory dataFactory, DispoApiConfiguration config, DispoConnector connector) {
        this.dataFactory = dataFactory;
        this.config = config;
        this.dispoConnector = connector;
    }

    @Override
    public List<DispoItem> importDirectory(Map<String, DispoItem> exisitingItems, File filesDir, OperationReport report) {
        this.vCastDir = String.valueOf(filesDir.getAbsolutePath()) + File.separator + "vcast";
        File f = new File(String.valueOf(this.vCastDir) + File.separator + "cover.db");
        VCastDataStore dataStore = VCastClient.newDataStore((String)f.getAbsolutePath());
        dataStore.setIsMCDC();
        dataStore.setIsBranch();
        Collection<VCastInstrumentedFile> instrumentedFiles = this.getInstrumentedFiles(dataStore, report);
        HashMap<String, File> nameToFileMap = this.createNameToFileMap(report);
        for (VCastInstrumentedFile instrumentedFile : instrumentedFiles) {
            this.processInstrumented(dataStore, instrumentedFile, nameToFileMap, report);
        }
        Collection<VCastResult> results = this.getResultFiles(dataStore);
        for (VCastResult result : results) {
            try {
                this.processResults(result, report);
            }
            catch (Exception exception) {
                report.addEntry("FAILURE", "VCast Error", DispoSummarySeverity.ERROR);
            }
        }
        this.processExceptionHandled(report);
        return this.createItems(exisitingItems, report);
    }

    private HashMap<String, File> createNameToFileMap(OperationReport report) {
        HashMap<String, File> fileNameToFileMap = new HashMap<String, File>();
        File vcastDir = new File(this.vCastDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lis") || name.endsWith(".LIS");
            }
        };
        File[] lisFiles = vcastDir.listFiles(filter);
        if (lisFiles != null) {
            File[] fileArray = lisFiles;
            int n = lisFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileNameLowerCase = this.normalizeLisFileName(file.getName());
                if (fileNameToFileMap.containsKey(fileNameLowerCase)) {
                    report.addEntry("DIRECTORY", String.format("Collision with file name: %s", fileNameLowerCase), DispoSummarySeverity.ERROR);
                } else {
                    fileNameToFileMap.put(fileNameLowerCase, file);
                }
                ++n2;
            }
        }
        return fileNameToFileMap;
    }

    private List<DispoItem> createItems(Map<String, DispoItem> exisitingItems, OperationReport report) {
        List<Object> toReturn;
        Collection<DispoItemData> items = this.datIdToItem.values();
        for (DispoItemData dispoItemData : items) {
            this.dataFactory.initDispoItem(dispoItemData);
            dispoItemData.setTotalPoints(String.valueOf(dispoItemData.getAnnotationsList().size() + dispoItemData.getDiscrepanciesList().size()));
        }
        if (!exisitingItems.isEmpty()) {
            toReturn = this.runCopier(exisitingItems, report, items);
        } else {
            toReturn = new ArrayList<DispoItemData>();
            toReturn.addAll(items);
        }
        for (DispoItem dispoItem : toReturn) {
            if (!dispoItem.getStatus().equalsIgnoreCase("incomplete")) continue;
            this.createPlaceHolderAnnotations((DispoItemData)dispoItem, exisitingItems, report);
        }
        return toReturn;
    }

    private List<DispoItem> runCopier(Map<String, DispoItem> exisitingItems, OperationReport report, Collection<DispoItemData> items) {
        DispoSetCopier copier = new DispoSetCopier(this.dispoConnector);
        ArrayList<DispoItemData> itemsFromImport = new ArrayList<DispoItemData>();
        itemsFromImport.addAll(items);
        HashMap<String, Set<DispoItemData>> namesToDestItems = new HashMap<String, Set<DispoItemData>>();
        for (DispoItemData item : itemsFromImport) {
            String name = item.getName();
            Set itemsWithSameName = (Set)namesToDestItems.get(name);
            if (itemsWithSameName == null) {
                HashSet<DispoItemData> set = new HashSet<DispoItemData>();
                set.add(item);
                namesToDestItems.put(name, set);
                continue;
            }
            itemsWithSameName.add(item);
            namesToDestItems.put(name, itemsWithSameName);
        }
        List<DispoItem> toReturn = copier.copyAllDispositions(namesToDestItems, exisitingItems.values(), false, null, report);
        return toReturn;
    }

    private void createPlaceHolderAnnotations(DispoItemData item, Map<String, DispoItem> exisitingItems, OperationReport report) {
        ArrayList<DispoItem> prevItems = new ArrayList<DispoItem>(exisitingItems.values());
        List<String> uncovered = this.dispoConnector.getAllUncoveredDiscprepancies((DispoItem)item);
        if (!uncovered.isEmpty()) {
            Map discrepanciesList = item.getDiscrepanciesList();
            for (String id : discrepanciesList.keySet()) {
                Discrepancy discrepancy = (Discrepancy)discrepanciesList.get(id);
                if (!uncovered.contains(discrepancy.getLocation())) continue;
                DispoAnnotationData uncoveredAnnotation = this.matchOldAnnotation(discrepancy, prevItems, item);
                if (uncoveredAnnotation != null) {
                    if (uncoveredAnnotation.getResolutionType().equalsIgnoreCase("Test_Script")) {
                        uncoveredAnnotation.setLastResolution(uncoveredAnnotation.getResolution());
                    } else if (uncoveredAnnotation.getResolutionType().equalsIgnoreCase("Exception_Handling")) {
                        uncoveredAnnotation.setLastResolution("Exception_Handling");
                    }
                    this.addBlankAnnotationForUncoveredLine(item, discrepancy.getLocation(), discrepancy.getText(), uncoveredAnnotation.getLastResolution());
                    continue;
                }
                this.addBlankAnnotationForUncoveredLine(item, discrepancy.getLocation(), discrepancy.getText(), "N/A");
            }
        }
    }

    private void processExceptionHandled(OperationReport report) {
        for (String datId : this.datIdsCoveredByException) {
            Matcher matcher = Pattern.compile("\\d*:\\d*:").matcher(datId);
            matcher.find();
            String itemDatId = matcher.group();
            DispoItemData item = this.datIdToItem.get(itemDatId);
            String line = datId.replaceAll("\\d*:\\d*:", "");
            line = line.replaceAll(":", "");
            String text = "";
            Discrepancy matchingDiscrepancy = this.matchDiscrepancy(line, item.getDiscrepanciesList());
            if (matchingDiscrepancy == null) continue;
            text = matchingDiscrepancy.getText();
            Map discrepancies = item.getDiscrepanciesList();
            discrepancies.remove(matchingDiscrepancy.getId());
            this.addAnnotationForCoveredLine(item, line, "Exception_Handling", "", text);
        }
    }

    private Collection<VCastInstrumentedFile> getInstrumentedFiles(VCastDataStore dataStore, OperationReport report) {
        ArrayList<VCastInstrumentedFile> instrumentedFiles = new ArrayList();
        try {
            instrumentedFiles = dataStore.getAllInstrumentedFiles();
        }
        catch (OseeCoreException oseeCoreException) {
            report.addEntry("SQL", String.format("SQL error while reading functions for directory: [%s]", this.vCastDir), DispoSummarySeverity.ERROR);
        }
        return instrumentedFiles;
    }

    private void processInstrumented(VCastDataStore dataStore, VCastInstrumentedFile instrumentedFile, HashMap<String, File> nameToFileMap, OperationReport report) {
        VCastSourceFileJoin sourceFile = null;
        try {
            sourceFile = dataStore.getSourceFileJoin(instrumentedFile);
        }
        catch (OseeCoreException ex) {
            report.addEntry("SQL", String.format("SQL error while reading source_files for instrumented_file id: [%s]. Error Message: [%s]", instrumentedFile.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        if (sourceFile != null) {
            String normalizedName;
            File file;
            int fileNum = sourceFile.getUnitIndex();
            String lisFileNameFullPath = instrumentedFile.getLISFile();
            if (!Strings.isValid((String)lisFileNameFullPath)) {
                report.addEntry("SQL", String.format("Error: instrumented_file has invalid LIS_file value.  ID:(" + instrumentedFile.getId() + ")", new Object[0]), DispoSummarySeverity.ERROR);
            }
            if ((file = nameToFileMap.get(normalizedName = this.normalizeLisFileName(lisFileNameFullPath))) != null) {
                VCastLisFileParser lisFileParser = new VCastLisFileParser(file);
                try {
                    lisFileParser.loadFileText();
                }
                catch (IOException iOException) {
                    report.addEntry("VCast", String.format("Could not load file: %s", normalizedName), DispoSummarySeverity.ERROR);
                }
                Collection<Object> functions = Collections.emptyList();
                try {
                    functions = dataStore.getFunctions(instrumentedFile);
                }
                catch (OseeCoreException oseeCoreException) {
                    report.addEntry("SQL", String.format("SQL error while reading functions for instrumented_file id: [%s]. Error Message: [%s]", instrumentedFile.getId(), oseeCoreException.getMessage()), DispoSummarySeverity.ERROR);
                }
                for (VCastFunction vCastFunction : functions) {
                    this.processFunction(instrumentedFile, lisFileParser, fileNum, dataStore, instrumentedFile, vCastFunction, dataStore.getIsMCDC(), report);
                }
            } else {
                report.addEntry("VCast", String.format("Could not find file: %s", normalizedName), DispoSummarySeverity.ERROR);
            }
        }
    }

    private void processFunction(VCastInstrumentedFile lisFile, VCastLisFileParser lisFileParser, int fileNum, VCastDataStore dataStore, VCastInstrumentedFile instrumentedFile, VCastFunction function, boolean isMCDCFile, OperationReport report) {
        int functionNum = function.getFindex();
        String itemName = "";
        DispoItemData newItem = new DispoItemData();
        newItem.setAnnotationsList(new ArrayList());
        VCastSourceFileJoin sourceFileJoin = dataStore.getSourceFileJoin(lisFile);
        itemName = String.valueOf(sourceFileJoin.getDisplayName()) + "." + function.getName();
        newItem.setName(itemName);
        newItem.setFileNumber(Integer.toString(fileNum));
        newItem.setMethodNumber(Integer.toString(functionNum));
        try {
            String fileName = sourceFileJoin.getDisplayName();
            String fullPathToFile = String.valueOf(this.vCastDir) + File.separator + fileName.replaceAll(this.config.getFileExtRegex(), ".LIS");
            Date lastModified = DispoUtil.getTimestampOfFile(fullPathToFile);
            newItem.setLastUpdate(lastModified);
        }
        catch (Throwable ex) {
            report.addEntry("Get Timestamp of File", String.format("Error retrieving the timestamp for [%s]. Error Message: [%s]", instrumentedFile.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        String datId = this.generateDatId(fileNum, functionNum);
        this.datIdToItem.put(datId, newItem);
        this.checkForMultiEnvRename(fileNum, instrumentedFile, newItem);
        Collection<Object> statementCoverageItems = Collections.emptyList();
        try {
            statementCoverageItems = dataStore.getStatementCoverageLines(function);
        }
        catch (OseeCoreException ex) {
            report.addEntry("SQL", String.format("SQL error while reading statement_coverages for instrumented_file id: [%s] and function id: [%s]. Error Message: [%s]", instrumentedFile.getId(), function.getId(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        HashMap<String, Discrepancy> discrepancies = new HashMap<String, Discrepancy>();
        for (VCastStatementCoverage vCastStatementCoverage : statementCoverageItems) {
            this.processStatement(lisFile, lisFileParser, fileNum, functionNum, function, vCastStatementCoverage, isMCDCFile, discrepancies, report);
        }
        newItem.setDiscrepanciesList(discrepancies);
    }

    private void checkForMultiEnvRename(int fileNum, VCastInstrumentedFile instrumentedFile, DispoItemData newItem) {
        String regexWithSeparator = String.format(".*?%svcast%s.*?\\d+\\.2\\.lis", File.separator, File.separator);
        if (instrumentedFile.getLISFile().matches(regexWithSeparator)) {
            String nameWithoutId = newItem.getName();
            String regex = "\\.2\\.";
            String nameWithId = nameWithoutId.replaceAll(regex, String.format(".%s.2.", fileNum));
            newItem.setName(nameWithId);
        }
    }

    private void processStatement(VCastInstrumentedFile lisFile, VCastLisFileParser lisFileParser, int fileNum, int functionNum, VCastFunction function, VCastStatementCoverage statementCoverageItem, boolean isMCDCFile, Map<String, Discrepancy> discrepancies, OperationReport report) {
        Integer functionNumber = function.getFindex();
        Integer lineNumber = statementCoverageItem.getLine();
        Pair lineData = null;
        try {
            lineData = lisFileParser.getSourceCodeForLine(functionNumber, lineNumber);
        }
        catch (Exception ex) {
            report.addEntry("SQL", String.format("Issue getting source code line [%s], [%s]", lisFile.getLISFile(), ex.getMessage()), DispoSummarySeverity.ERROR);
        }
        String location = "";
        if (lineData != null) {
            boolean isMCDCPair = statementCoverageItem.getIsMCDCPair();
            if (isMCDCPair) {
                location = String.format("%s.%s.%s", lineNumber, statementCoverageItem.getAbbrevCondition(), "T");
                String location2 = String.format("%s.%s.%s", lineNumber, statementCoverageItem.getAbbrevCondition(), "F");
                if (!(((String)lineData.getFirst()).matches(WHEN_FOR) || ((String)lineData.getFirst()).matches(CASE_STATEMENT) || ((String)lineData.getFirst()).matches(WHILE_ONE))) {
                    String text = statementCoverageItem.getFullCondition();
                    this.addDiscrepancy(discrepancies, location, text);
                    this.addDiscrepancy(discrepancies, location2, text);
                } else {
                    String text = ((String)lineData.getFirst()).trim();
                    this.addDiscrepancy(discrepancies, location, text);
                }
            } else {
                String text = ((String)lineData.getFirst()).trim();
                if (statementCoverageItem.getNumConditions() == 2) {
                    location = String.format("%s.%s", lineNumber, "T");
                    String locationF = String.format("%s.%s", lineNumber, "F");
                    if (!(((String)lineData.getFirst()).matches(WHEN_FOR) || ((String)lineData.getFirst()).matches(EXIT_WHEN) || ((String)lineData.getFirst()).matches(LOG))) {
                        this.addDiscrepancy(discrepancies, location, text);
                        this.addDiscrepancy(discrepancies, locationF, text);
                    } else {
                        this.addDiscrepancy(discrepancies, location, text);
                    }
                } else if (statementCoverageItem.getNumConditions() == 1 && ((String)lineData.getFirst()).matches(WHEN_CASE)) {
                    location = String.format("%s.%s", lineNumber, "T");
                    this.addDiscrepancy(discrepancies, location, text);
                } else {
                    location = String.valueOf(lineNumber);
                    this.addDiscrepancy(discrepancies, location, text);
                }
            }
            if (((Boolean)lineData.getSecond()).booleanValue()) {
                String datId = this.generateDatId(fileNum, functionNum, location);
                this.datIdsCoveredByException.add(datId);
            }
        }
    }

    private void addDiscrepancy(Map<String, Discrepancy> discrepancies, String location, String text) {
        Discrepancy newDiscrepancy = new Discrepancy();
        newDiscrepancy.setLocation(location);
        newDiscrepancy.setText(text);
        String id = String.valueOf(Lib.generateUuid());
        newDiscrepancy.setId(id);
        discrepancies.put(id, newDiscrepancy);
    }

    private String generateDatId(Object ... ids) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            sb.append(id);
            sb.append(":");
            ++n2;
        }
        return sb.toString();
    }

    private void processResults(VCastResult result, OperationReport report) throws Exception {
        String resultPath = result.getPath();
        String resultPathAbs = String.valueOf(this.vCastDir) + File.separator + resultPath;
        File resultsFile = new File(resultPathAbs);
        if (!resultsFile.exists()) {
            boolean fileExists = this.findAndProcessResultFile(resultsFile, resultPath, report);
            if (!fileExists) {
                report.addEntry("SQL", String.format("Could not find DAT file [%s]", resultPathAbs), DispoSummarySeverity.WARNING);
            }
        } else {
            this.process(report, resultPath, resultsFile);
        }
    }

    private boolean findAndProcessResultFile(File resultsFile, String resultPath, OperationReport report) {
        ArrayList<File> resultsDirs = new ArrayList<File>();
        resultsDirs.add(new File(String.valueOf(this.vCastDir) + File.separator + RESULTS));
        resultsDirs.add(new File(String.valueOf(this.vCastDir) + File.separator + RESULTS + File.separator + IMPORTED_RESULTS));
        for (File resultsDir : resultsDirs) {
            File[] files;
            if (!resultsDir.exists() || (files = resultsDir.listFiles()) == null) continue;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String inputF = file.toString();
                String outputF = inputF.replaceAll(this.config.getResultsFileExtRegex(), "");
                if (outputF.toString().equalsIgnoreCase(resultsFile.toString())) {
                    this.process(report, resultPath, file);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void process(OperationReport report, String resultPath, File resultsFile) {
        block8: {
            if (!this.isDuplicateFile(resultsFile, report)) {
                BufferedReader br = null;
                try {
                    try {
                        String resultsLine;
                        br = new BufferedReader(new FileReader(resultsFile));
                        while ((resultsLine = br.readLine()) != null) {
                            if (!Strings.isValid((String)resultsLine)) continue;
                            Result datFileSyntaxResult = VCastValidateDatFileSyntax.validateDatFileSyntax((String)resultsLine);
                            if (!datFileSyntaxResult.isTrue()) {
                                report.addEntry("SQL", String.format("This line [%s] is not in proper format. In DAT file [%s]", resultsLine, resultsFile.getName()), DispoSummarySeverity.WARNING);
                                continue;
                            }
                            if (this.alreadyUsedDatIds.contains(resultsLine)) continue;
                            this.processDatFileLine(report, resultPath, resultsFile, resultsLine);
                        }
                    }
                    catch (Exception ex) {
                        report.addEntry("EXCEPTION", ex.getMessage(), DispoSummarySeverity.ERROR);
                        Lib.close((AutoCloseable)br);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    Lib.close(br);
                    throw throwable;
                }
                Lib.close((AutoCloseable)br);
            }
        }
    }

    private void processDatFileLine(OperationReport report, String resultPath, File resultsFile, String resultsLine) {
        this.alreadyUsedDatIds.add(resultsLine);
        StringTokenizer st = new StringTokenizer(resultsLine);
        int count = st.countTokens();
        if (count == 3) {
            Matcher m = fileMethod3LineNumberPattern.matcher(resultsLine);
            if (m.find()) {
                this.processSingleResult(resultPath, m);
            }
        } else if (count == 4) {
            Matcher m = fileMethod4LineNumberPlusTokenPattern.matcher(resultsLine);
            if (m.find()) {
                this.processSingleResultBranch(resultPath, m);
            }
        } else if (count == 5) {
            Matcher m = fileMethod5LineNumberPattern.matcher(resultsLine);
            if (m.find()) {
                this.processMultiResultMCDC(resultPath, m);
            }
        } else {
            report.addEntry("RESULTS FILE PARSE", String.format("This line [%s] could not be parsed. In DAT file [%s]", resultsLine, resultsFile.getName()), DispoSummarySeverity.WARNING);
        }
    }

    private boolean isDuplicateFile(File file, OperationReport report) {
        String normalizedFileName = file.getName().replaceAll("//....", "");
        if (this.alreadyUsedFileNames.contains(normalizedFileName)) {
            report.addEntry(file.getName(), "Duplicate File skipped", DispoSummarySeverity.WARNING);
            return true;
        }
        this.alreadyUsedFileNames.add(normalizedFileName);
        return false;
    }

    private void processSingleResult(String resultPath, Matcher m) {
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null) {
            String location = m.group(3);
            String discrepancyText = "";
            Discrepancy matchingDiscrepancy = this.matchDiscrepancy(location, item.getDiscrepanciesList());
            if (matchingDiscrepancy != null) {
                discrepancyText = matchingDiscrepancy.getText();
                Map discrepancies = item.getDiscrepanciesList();
                discrepancies.remove(matchingDiscrepancy.getId());
                this.datIdsCoveredByException.remove(this.generateDatId(m.group(1), m.group(2), m.group(3)));
                item.setDiscrepanciesList(discrepancies);
                this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, discrepancyText);
            }
        }
    }

    private void processSingleResultBranch(String resultPath, Matcher m) {
        String location;
        Discrepancy matchingDiscrepancy;
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null && (matchingDiscrepancy = this.matchDiscrepancy(location = String.valueOf(m.group(3)) + "." + m.group(4), item.getDiscrepanciesList())) != null) {
            String text = matchingDiscrepancy.getText();
            Map discrepancies = item.getDiscrepanciesList();
            discrepancies.remove(matchingDiscrepancy.getId());
            this.datIdsCoveredByException.remove(this.generateDatId(m.group(1), m.group(2), m.group(3), m.group(4)));
            item.setDiscrepanciesList(discrepancies);
            this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, text);
        }
    }

    private void processMultiResultMCDC(String resultPath, Matcher m) {
        DispoItemData item = this.datIdToItem.get(this.generateDatId(m.group(1), m.group(2)));
        if (item != null) {
            Integer lineNumber = Integer.valueOf(m.group(3));
            Integer bitsValue = Integer.valueOf(m.group(4));
            Integer bitsMask = Integer.valueOf(m.group(5));
            Map<String, Boolean> bitsTrueMap = this.getBitToBoolean(Integer.toString(bitsValue, 2), Integer.toString(bitsMask, 2));
            for (String abbrevCond : bitsTrueMap.keySet()) {
                String TorF = "";
                TorF = bitsTrueMap.get(abbrevCond) == null ? " " : (bitsTrueMap.get(abbrevCond) != false ? "T" : "F");
                String location = this.formatLocation(lineNumber, abbrevCond, TorF);
                Discrepancy matchingDiscrepancy = this.matchDiscrepancy(location, item.getDiscrepanciesList());
                if (matchingDiscrepancy == null) continue;
                String text = matchingDiscrepancy.getText();
                Map discrepancies = item.getDiscrepanciesList();
                discrepancies.remove(matchingDiscrepancy.getId());
                this.datIdsCoveredByException.remove(this.generateDatId(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5)));
                item.setDiscrepanciesList(discrepancies);
                this.addAnnotationForCoveredLine(item, location, "Test_Script", resultPath, text);
            }
        }
    }

    private String formatLocation(int lineNumber, String abbrevCond, String TorF) {
        if (abbrevCond.length() != 1 || abbrevCond.charAt(0) < 'A' || abbrevCond.charAt(0) > 'Z') {
            return String.format("%s.%s.%s", lineNumber, abbrevCond, TorF);
        }
        return String.format("%s.%s.%s", lineNumber, String.valueOf(abbrevCond.charAt(0) - 64) + " (" + abbrevCond + ")", TorF);
    }

    private Map<String, Boolean> getBitToBoolean(String bitsValue, String bitsMask) {
        String key;
        HashMap<String, Boolean> toReturn = new HashMap<String, Boolean>();
        char[] bitsMaskedArray = bitsMask.toCharArray();
        char[] bitsValueArray = bitsValue.toCharArray();
        int totalResultIndex = bitsValueArray.length - 1;
        int sizeDelta = bitsMaskedArray.length - bitsValueArray.length;
        int highestChar = 63 + bitsMaskedArray.length;
        int i = 0;
        while (i < sizeDelta) {
            char valueMaskBit = bitsMaskedArray[i];
            char c = (char)highestChar--;
            key = Character.toString(c);
            if (valueMaskBit == '1') {
                toReturn.put(key, false);
            } else {
                toReturn.put(key, null);
            }
            ++i;
        }
        i = 0;
        while (i < bitsValueArray.length) {
            char valueC = bitsValueArray[i];
            char valueMaskBit = bitsMaskedArray[i + sizeDelta];
            key = "";
            if (i != totalResultIndex) {
                char c = (char)highestChar--;
                key = Character.toString(c);
            } else {
                key = "RESULT";
            }
            if (valueMaskBit == '0' && valueC == '0') {
                toReturn.put(key, null);
            } else {
                toReturn.put(key, valueC == '1');
            }
            ++i;
        }
        return toReturn;
    }

    private Discrepancy matchDiscrepancy(String location, Map<String, Discrepancy> discrepancies) {
        Discrepancy toReturn = null;
        for (String key : discrepancies.keySet()) {
            Discrepancy discrepancy = discrepancies.get(key);
            if (!String.valueOf(discrepancy.getLocation()).equals(location)) continue;
            toReturn = discrepancy;
            break;
        }
        return toReturn;
    }

    private DispoAnnotationData matchOldAnnotation(Discrepancy discrepancy, List<DispoItem> oldItems, DispoItemData item) {
        DispoAnnotationData toReturn = null;
        DispoItem dispoItem = null;
        if (!oldItems.isEmpty()) {
            for (DispoItem oldItem : oldItems) {
                if (!String.valueOf(oldItem.getName()).equals(item.getName())) continue;
                dispoItem = oldItem;
                break;
            }
            for (DispoAnnotationData value : dispoItem.getAnnotationsList()) {
                if (!String.valueOf(value.getLocationRefs()).equals(discrepancy.getLocation())) continue;
                toReturn = value;
                return toReturn;
            }
        }
        return toReturn;
    }

    private void addBlankAnnotationForUncoveredLine(DispoItemData item, String location, String text, String lastResolution) {
        DispoAnnotationData newAnnotation = new DispoAnnotationData();
        this.dataFactory.initAnnotation(newAnnotation);
        String idOfNewAnnotation = this.dataFactory.getNewId();
        newAnnotation.setId(idOfNewAnnotation);
        newAnnotation.setIsDefault(false);
        newAnnotation.setLocationRefs(location);
        newAnnotation.setResolutionType("");
        newAnnotation.setResolution("");
        newAnnotation.setLastResolution(lastResolution);
        newAnnotation.setIsResolutionValid(false);
        newAnnotation.setCustomerNotes(text);
        this.dispoConnector.connectAnnotation(newAnnotation, item.getDiscrepanciesList());
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        newAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, newAnnotation);
    }

    private void addAnnotationForCoveredLine(DispoItemData item, String location, String resolutionType, String coveringFile, String text) {
        DispoAnnotationData newAnnotation = new DispoAnnotationData();
        this.dataFactory.initAnnotation(newAnnotation);
        String idOfNewAnnotation = this.dataFactory.getNewId();
        newAnnotation.setId(idOfNewAnnotation);
        newAnnotation.setIsDefault(true);
        newAnnotation.setLocationRefs(location);
        newAnnotation.setResolutionType(resolutionType);
        newAnnotation.setResolution(coveringFile);
        newAnnotation.setLastResolution("N/A");
        newAnnotation.setIsResolutionValid(true);
        newAnnotation.setCustomerNotes(text);
        List annotationsList = item.getAnnotationsList();
        int newIndex = annotationsList.size();
        newAnnotation.setIndex(newIndex);
        annotationsList.add(newIndex, newAnnotation);
    }

    private Collection<VCastResult> getResultFiles(VCastDataStore dataStore) {
        Collection results = null;
        results = dataStore.getAllResults();
        return results;
    }

    private String normalizeLisFileName(String fileName) {
        return fileName.replaceAll("^.*(\\\\|\\/)", "").toLowerCase();
    }
}

