/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoImporterApi;
import org.eclipse.osee.disposition.rest.internal.DispoDataFactory;
import org.eclipse.osee.disposition.rest.internal.importer.DiscrepancyParser;
import org.eclipse.osee.disposition.rest.internal.importer.DispoItemDataCopier;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;

public class TmoImporter
implements DispoImporterApi {
    private final DispoDataFactory dataFactory;
    private final ExecutorAdmin executor;

    TmoImporter(DispoDataFactory dataFactory, ExecutorAdmin executor, Log logger) {
        this.dataFactory = dataFactory;
        this.executor = executor;
    }

    @Override
    public List<DispoItem> importDirectory(Map<String, DispoItem> exisitingItems, File tmoDirectory, OperationReport report) {
        LinkedList<DispoItem> toReturn = new LinkedList<DispoItem>();
        if (tmoDirectory.isDirectory()) {
            List listOfFiles = Lib.recursivelyListFiles((File)tmoDirectory, (Pattern)Pattern.compile(".*\\.tmo"));
            int numThreads = 8;
            int partitionSize = listOfFiles.size() / numThreads;
            int remainder = listOfFiles.size() % numThreads;
            int startIndex = 0;
            int endIndex = 0;
            LinkedList<Future> futures = new LinkedList<Future>();
            int i = 0;
            while (i < numThreads) {
                startIndex = endIndex;
                endIndex = startIndex + partitionSize;
                if (i == 0) {
                    endIndex += remainder;
                }
                List<File> sublist = listOfFiles.subList(startIndex, endIndex);
                Worker worker = new Worker(sublist, this.dataFactory, exisitingItems, report);
                try {
                    Future future = this.executor.submit("Dispo tmo importer", (Callable)worker);
                    futures.add(future);
                }
                catch (Exception ex) {
                    report.addEntry("FATAL", ex.getLocalizedMessage(), DispoSummarySeverity.ERROR);
                }
                ++i;
            }
            for (Future future : futures) {
                try {
                    toReturn.addAll((Collection)future.get());
                }
                catch (Exception ex) {
                    report.addEntry("FATAL", ex.getLocalizedMessage(), DispoSummarySeverity.ERROR);
                }
            }
        }
        return toReturn;
    }

    private static final class Worker
    implements Callable<List<DispoItem>> {
        private final List<File> sublist;
        private final DispoDataFactory dataFactory;
        Map<String, DispoItem> exisitingItems;
        private final OperationReport operationReport;

        public Worker(List<File> sublist, DispoDataFactory dataFactory, Map<String, DispoItem> exisitingItems, OperationReport operationReport) {
            this.sublist = sublist;
            this.dataFactory = dataFactory;
            this.exisitingItems = exisitingItems;
            this.operationReport = operationReport;
        }

        @Override
        public List<DispoItem> call() throws Exception {
            LinkedList<DispoItem> fromThread = new LinkedList<DispoItem>();
            for (File file : this.sublist) {
                FileInputStream inputStream = null;
                try {
                    try {
                        inputStream = new FileInputStream(file);
                        String sanitizedFileName = file.getName().replaceAll("\\..*", "");
                        DispoItemData itemToBuild = new DispoItemData();
                        DiscrepancyParser.MutableString message = new DiscrepancyParser.MutableString();
                        MutableBoolean isSameFile = new MutableBoolean(false);
                        MutableBoolean isExeptioned = new MutableBoolean(false);
                        if (this.exisitingItems.containsKey(sanitizedFileName)) {
                            DispoItem oldItem = this.exisitingItems.get(sanitizedFileName);
                            Date lastUpdate = oldItem.getLastUpdate();
                            DiscrepancyParser.buildItemFromFile(itemToBuild, sanitizedFileName, inputStream, false, lastUpdate, isSameFile, isExeptioned, message);
                            if (isExeptioned.getValue()) {
                                this.operationReport.addEntry(sanitizedFileName, message.getValue(), DispoSummarySeverity.ERROR);
                            } else if (!isSameFile.getValue()) {
                                itemToBuild.setGuid((String)oldItem.getGuid());
                                itemToBuild.setAnnotationsList(new ArrayList());
                                if (itemToBuild.getDiscrepanciesList().size() > 0) {
                                    DispoItemDataCopier.copyOldItemData(oldItem, itemToBuild, this.operationReport);
                                }
                                this.dataFactory.setStatus(itemToBuild);
                                fromThread.add((DispoItem)itemToBuild);
                            }
                        } else {
                            DiscrepancyParser.buildItemFromFile(itemToBuild, sanitizedFileName, inputStream, true, new Date(), isSameFile, isExeptioned, message);
                            if (isExeptioned.getValue()) {
                                this.operationReport.addEntry(sanitizedFileName, message.getValue(), DispoSummarySeverity.ERROR);
                            } else {
                                this.dataFactory.initDispoItem(itemToBuild);
                                fromThread.add((DispoItem)itemToBuild);
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.operationReport.addEntry("ALL", ex.getMessage(), DispoSummarySeverity.ERROR);
                        Lib.close((AutoCloseable)inputStream);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Lib.close(inputStream);
                    throw throwable;
                }
                Lib.close((AutoCloseable)inputStream);
            }
            return fromThread;
        }
    }
}

