/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.types;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.OrcsTypesDataStore;
import org.eclipse.osee.orcs.db.internal.callable.PurgeArtifactTypeDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.PurgeAttributeTypeDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.callable.PurgeRelationTypeDatabaseTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class TypesModule {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;

    public TypesModule(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
    }

    public OrcsTypesDataStore createTypesDataStore() {
        return new OrcsTypesDataStore(){

            public Callable<Void> purgeArtifactsByArtifactType(OrcsSession session, Collection<? extends ArtifactTypeToken> typesToPurge) {
                return new PurgeArtifactTypeDatabaseTxCallable(TypesModule.this.logger, session, TypesModule.this.jdbcClient, typesToPurge);
            }

            public Callable<Void> purgeAttributesByAttributeType(OrcsSession session, Collection<? extends AttributeTypeId> typesToPurge) {
                return new PurgeAttributeTypeDatabaseTxCallable(TypesModule.this.logger, session, TypesModule.this.jdbcClient, TypesModule.this.joinFactory, typesToPurge);
            }

            public Callable<Void> purgeRelationsByRelationType(OrcsSession session, Collection<? extends RelationTypeToken> typesToPurge) {
                return new PurgeRelationTypeDatabaseTxCallable(TypesModule.this.logger, session, TypesModule.this.jdbcClient, typesToPurge);
            }
        };
    }
}

