/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.OrcsChangeSet;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.transaction.TxSqlBuilder;

public class TransactionWriter {
    protected static final String UPDATE_TXS_NOT_CURRENT = "UPDATE osee_txs SET tx_current = " + TxCurrent.NOT_CURRENT + " WHERE branch_id = ? AND transaction_id = ? AND gamma_id = ?";
    private static final String INSERT_ARTIFACT = "INSERT INTO osee_artifact (art_id, art_type_id, gamma_id, guid) VALUES (?,?,?,?)";
    private static final String INSERT_ATTRIBUTE = "INSERT INTO osee_attribute (attr_id, attr_type_id, gamma_id, art_id, value, uri) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_RELATION_TABLE = "INSERT INTO osee_relation_link (rel_link_id, rel_link_type_id, gamma_id, a_art_id, b_art_id, rationale) VALUES (?,?,?,?,?,?)";
    private static final String INSERT_TUPLES2_TABLE = "INSERT INTO osee_tuple2 (tuple_type, e1, e2, gamma_id) VALUES (?,?,?,?)";
    private static final String INSERT_TUPLES3_TABLE = "INSERT INTO osee_tuple3 (tuple_type, e1, e2, e3, gamma_id) VALUES (?,?,?,?,?)";
    private static final String INSERT_TUPLES4_TABLE = "INSERT INTO osee_tuple4 (tuple_type, e1, e2, e3, e4, gamma_id) VALUES (?,?,?,?,?,?)";
    private static final String INSERT_INTO_TRANSACTION_TABLE = "INSERT INTO osee_txs (transaction_id, gamma_id, mod_type, tx_current, branch_id, app_id) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_INTO_TRANSACTION_DETAIL = "INSERT INTO osee_tx_details (transaction_id, osee_comment, time, author, branch_id, tx_type, build_id) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String TX_GET_PREVIOUS_TX_NOT_CURRENT_ARTIFACTS = "SELECT%s txs.transaction_id, txs.gamma_id FROM osee_join_id jid, osee_artifact art, osee_txs txs WHERE jid.query_id = ? AND art.art_id = jid.id AND art.gamma_id = txs.gamma_id AND txs.branch_id = ? AND txs.tx_current <> " + TxCurrent.NOT_CURRENT;
    private static final String TX_GET_PREVIOUS_TX_NOT_CURRENT_ATTRIBUTES = "SELECT%s txs.transaction_id, txs.gamma_id FROM osee_join_id jid, osee_attribute attr, osee_txs txs WHERE jid.query_id = ? AND attr.attr_id = jid.id AND attr.gamma_id = txs.gamma_id AND txs.branch_id = ? AND txs.tx_current <> " + TxCurrent.NOT_CURRENT;
    private static final String TX_GET_PREVIOUS_TX_NOT_CURRENT_RELATIONS = "SELECT%s txs.transaction_id, txs.gamma_id FROM osee_join_id jid, osee_relation_link rel, osee_txs txs WHERE jid.query_id = ? AND rel.rel_link_id = jid.id AND rel.gamma_id = txs.gamma_id AND txs.branch_id = ? AND txs.tx_current <> " + TxCurrent.NOT_CURRENT;
    private static final String TX_GET_PREVIOUS_TX_NOT_CURRENT_TUPLE = "SELECT%s txs.transaction_id, txs.gamma_id FROM osee_join_id jid, osee_txs txs WHERE jid.query_id = ? AND jid.id = txs.gamma_id AND txs.branch_id = ?   AND txs.tx_current <> " + TxCurrent.NOT_CURRENT;
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final TxSqlBuilder sqlBuilder;
    private List<DataProxy<?>> binaryStores;

    public TransactionWriter(Log logger, JdbcClient jdbcClient, TxSqlBuilder sqlBuilder) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.sqlBuilder = sqlBuilder;
    }

    protected List<DataProxy<?>> getBinaryStores() {
        return this.binaryStores;
    }

    public void rollback() {
        for (DataProxy<?> proxy : this.getBinaryStores()) {
            try {
                proxy.rollBack();
            }
            catch (OseeCoreException ex1) {
                this.logger.error((Throwable)ex1, "Error during binary rollback [%s]", new Object[]{proxy});
            }
        }
    }

    public void write(JdbcConnection connection, TransactionReadable tx, OrcsChangeSet txData) {
        this.sqlBuilder.accept(tx, txData);
        try {
            this.binaryStores = this.sqlBuilder.getBinaryStores();
            for (DataProxy<?> proxy : this.binaryStores) {
                proxy.persist();
            }
            this.sqlBuilder.updateAfterBinaryStorePersist();
            ArrayList<Object[]> txNotCurrentData = new ArrayList<Object[]>();
            for (Map.Entry<SqlOrderEnum, IdJoinQuery> entry : this.sqlBuilder.getTxNotCurrents()) {
                this.fetchTxNotCurrent(connection, tx.getBranch(), txNotCurrentData, this.jdbcClient.injectOrderedHint(entry.getKey().getTxsNotCurrentQuery()), entry.getValue());
            }
            SqlOrderEnum[] sqlOrderEnumArray = SqlOrderEnum.values();
            int n = sqlOrderEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                SqlOrderEnum key = sqlOrderEnumArray[n2];
                List<Object[]> data = this.sqlBuilder.getInsertData(key);
                if (data != null && !data.isEmpty()) {
                    this.jdbcClient.runBatchUpdate(connection, key.getInsertSql(), data);
                }
                ++n2;
            }
            this.jdbcClient.runBatchUpdate(connection, UPDATE_TXS_NOT_CURRENT, txNotCurrentData);
        }
        finally {
            this.sqlBuilder.clear();
        }
    }

    private void fetchTxNotCurrent(JdbcConnection connection, BranchId branch, List<Object[]> results, String query, AbstractJoinQuery join) {
        try {
            join.store();
            Throwable throwable = null;
            Object var7_8 = null;
            try (JdbcStatement chStmt = this.jdbcClient.getStatement(connection);){
                chStmt.runPreparedQuery(query, new Object[]{join.getQueryId(), branch});
                while (chStmt.next()) {
                    results.add(new Object[]{branch, chStmt.getLong("transaction_id"), chStmt.getLong("gamma_id")});
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            join.close();
        }
    }

    static /* synthetic */ String access$0() {
        return TX_GET_PREVIOUS_TX_NOT_CURRENT_ARTIFACTS;
    }

    static /* synthetic */ String access$1() {
        return TX_GET_PREVIOUS_TX_NOT_CURRENT_ATTRIBUTES;
    }

    static /* synthetic */ String access$2() {
        return TX_GET_PREVIOUS_TX_NOT_CURRENT_RELATIONS;
    }

    static /* synthetic */ String access$3() {
        return TX_GET_PREVIOUS_TX_NOT_CURRENT_TUPLE;
    }

    public static enum SqlOrderEnum {
        ARTIFACTS("INSERT INTO osee_artifact (art_id, art_type_id, gamma_id, guid) VALUES (?,?,?,?)", TransactionWriter.access$0()),
        ATTRIBUTES("INSERT INTO osee_attribute (attr_id, attr_type_id, gamma_id, art_id, value, uri) VALUES (?, ?, ?, ?, ?, ?)", TransactionWriter.access$1()),
        RELATIONS("INSERT INTO osee_relation_link (rel_link_id, rel_link_type_id, gamma_id, a_art_id, b_art_id, rationale) VALUES (?,?,?,?,?,?)", TransactionWriter.access$2()),
        TUPLES2("INSERT INTO osee_tuple2 (tuple_type, e1, e2, gamma_id) VALUES (?,?,?,?)", TransactionWriter.access$3()),
        TUPLES3("INSERT INTO osee_tuple3 (tuple_type, e1, e2, e3, gamma_id) VALUES (?,?,?,?,?)", TransactionWriter.access$3()),
        TUPLES4("INSERT INTO osee_tuple4 (tuple_type, e1, e2, e3, e4, gamma_id) VALUES (?,?,?,?,?,?)", TransactionWriter.access$3()),
        TXS_DETAIL("INSERT INTO osee_tx_details (transaction_id, osee_comment, time, author, branch_id, tx_type, build_id) VALUES (?, ?, ?, ?, ?, ?, ?)"),
        TXS("INSERT INTO osee_txs (transaction_id, gamma_id, mod_type, tx_current, branch_id, app_id) VALUES (?, ?, ?, ?, ?, ?)");

        private String notCurrentSearch;
        private String sql;

        private SqlOrderEnum(String sql) {
            this.sql = sql;
            this.notCurrentSearch = null;
        }

        private SqlOrderEnum(String sql, String notCurrentSearch) {
            this.sql = sql;
            this.notCurrentSearch = notCurrentSearch;
        }

        public boolean hasTxNotCurrentQuery() {
            return this.notCurrentSearch != null;
        }

        public String getTxsNotCurrentQuery() {
            return this.notCurrentSearch;
        }

        public String getInsertSql() {
            return this.sql;
        }
    }
}

