/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.executor.CancellableRunnable;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.CountingLoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAttributeKeywords;
import org.eclipse.osee.orcs.db.internal.loader.LoadUtil;
import org.eclipse.osee.orcs.db.internal.loader.data.AttributeDataImpl;
import org.eclipse.osee.orcs.db.internal.search.QueryFilterFactory;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.util.AttributeDataMatcher;
import org.eclipse.osee.orcs.db.internal.search.util.LoadDataBuffer;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;

public class QueryFilterFactoryImpl
implements QueryFilterFactory {
    private final Log logger;
    private final ExecutorAdmin executorAdmin;
    private final AttributeDataMatcher matcher;
    private static final AttributeData END_OF_QUEUE = new AttributeDataImpl(null);

    public QueryFilterFactoryImpl(Log logger, ExecutorAdmin executorAdmin, AttributeDataMatcher matcher) {
        this.logger = logger;
        this.executorAdmin = executorAdmin;
        this.matcher = matcher;
    }

    @Override
    public CountingLoadDataHandler createHandler(QueryData queryData, QuerySqlContext queryContext, LoadDataHandler handler) {
        ObjectCountingHandler countingHandler;
        List criterias = queryData.getCriteriaByType(CriteriaAttributeKeywords.class);
        if (criterias.isEmpty()) {
            countingHandler = new ObjectCountingHandler(handler);
        } else {
            int initialSize = this.computeFetchSize(queryContext);
            LoadDataBuffer buffer = new LoadDataBuffer(initialSize);
            ConsumerImpl consumer = new ConsumerImpl(criterias);
            countingHandler = new AttributeDataProducer(buffer, handler, consumer);
        }
        return countingHandler;
    }

    private int computeFetchSize(SqlContext sqlContext) {
        int fetchSize = 10;
        for (AbstractJoinQuery join : sqlContext.getJoins()) {
            fetchSize = Math.max(fetchSize, join.size());
        }
        return LoadUtil.computeFetchSize(fetchSize);
    }

    private final class AttributeDataProducer
    extends BufferedLoadDataHandler {
        private final Consumer consumer;
        private final Set<Integer> acceptedArtIds;

        public AttributeDataProducer(LoadDataBuffer buffer, LoadDataHandler handler, Consumer consumer) {
            super(handler, buffer);
            this.acceptedArtIds = new ConcurrentSkipListSet<Integer>();
            this.consumer = consumer;
        }

        private void reset() {
            this.acceptedArtIds.clear();
            this.getBuffer().clear();
        }

        public void onLoadStart() {
            this.reset();
            this.consumer.onLoadStart();
            super.onLoadStart();
        }

        @Override
        public <T> void onData(AttributeData<T> data) {
            super.onData(data);
            this.consumer.onData(data, (LoadDataHandler)this);
        }

        public <T> void onData(AttributeData<T> data, MatchLocation match) {
            Integer artId = data.getArtifactId().getIdIntValue();
            this.acceptedArtIds.add(artId);
            this.forwardArtifacts(artId);
            super.onData(data, match);
        }

        private void forwardArtifacts(int artifactId) {
            LoadDataBuffer buffer = this.getBuffer();
            LoadDataHandler handler = this.getHandler();
            if (handler != null) {
                ArtifactData art = buffer.removeArtifactByArtId(artifactId);
                Iterable<AttributeData<?>> attrs = buffer.removeAttributesByArtId(artifactId);
                Iterable<RelationData> rels = buffer.removeRelationsByArtId(artifactId);
                if (art != null) {
                    handler.onData(art);
                }
                if (attrs != null) {
                    for (AttributeData<?> attr : attrs) {
                        handler.onData(attr);
                    }
                }
                if (rels != null) {
                    for (RelationData rel : rels) {
                        handler.onData(rel);
                    }
                }
            }
        }

        private void forwardArtifacts() {
            for (int artifactId : this.acceptedArtIds) {
                this.forwardArtifacts(artifactId);
            }
        }

        public void onLoadEnd() {
            try {
                try {
                    this.consumer.onLoadEnd();
                    this.forwardArtifacts();
                }
                catch (Exception ex) {
                    QueryFilterFactoryImpl.this.logger.error((Throwable)ex, "Error waiting for query post process results", new Object[0]);
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    this.getCounter().getAndSet(this.acceptedArtIds.size());
                    this.reset();
                    super.onLoadEnd();
                }
            }
            finally {
                this.getCounter().getAndSet(this.acceptedArtIds.size());
                this.reset();
                super.onLoadEnd();
            }
        }
    }

    private static class BufferedLoadDataHandler
    extends ObjectCountingHandler {
        private final LoadDataBuffer buffer;

        public BufferedLoadDataHandler(LoadDataHandler handler, LoadDataBuffer buffer) {
            super(handler);
            this.buffer = buffer;
        }

        protected LoadDataBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void onData(ArtifactData data) {
            this.buffer.addData(data);
        }

        public <T> void onData(AttributeData<T> data) {
            this.buffer.addData(data);
        }

        public void onData(RelationData data) {
            this.buffer.addData(data);
        }
    }

    private static interface Consumer {
        public void onLoadStart();

        public void onData(AttributeData var1, LoadDataHandler var2);

        public void onLoadEnd();
    }

    private final class ConsumerImpl
    implements Consumer {
        private final List<CriteriaAttributeKeywords> criterias;
        private final AtomicBoolean executorStarted = new AtomicBoolean();
        private final LinkedBlockingQueue<AttributeData> dataToProcess = new LinkedBlockingQueue();
        private Future<?> future;

        public ConsumerImpl(List<CriteriaAttributeKeywords> criterias) {
            this.criterias = criterias;
        }

        @Override
        public void onLoadStart() {
            this.executorStarted.set(false);
            this.dataToProcess.clear();
            if (this.future != null) {
                this.cancelFutures();
                this.future = null;
            }
        }

        @Override
        public void onData(AttributeData data, LoadDataHandler handler) {
            this.addToQueue(data, handler);
        }

        private void addToQueue(AttributeData data, LoadDataHandler handler) {
            this.dataToProcess.offer(data);
            if (this.executorStarted.compareAndSet(false, true)) {
                this.future = QueryFilterFactoryImpl.this.executorAdmin.submit("AttributeData loader", this.createConsumer(handler));
            }
        }

        private Runnable createConsumer(final LoadDataHandler handler) {
            return new CancellableRunnable(){

                public void run() {
                    try {
                        boolean isEndOfQueue = false;
                        HashMap artIdToCriteriaTracker = Maps.newHashMap();
                        while (!isEndOfQueue) {
                            HashSet<AttributeData> toProcess = new HashSet<AttributeData>();
                            AttributeData entry = (AttributeData)ConsumerImpl.this.dataToProcess.take();
                            ConsumerImpl.this.dataToProcess.drainTo(toProcess);
                            toProcess.add(entry);
                            for (AttributeData item : toProcess) {
                                if (END_OF_QUEUE != item) {
                                    CriteriaMatchTracker tracker = (CriteriaMatchTracker)artIdToCriteriaTracker.get(item.getArtifactId());
                                    if (tracker == null) {
                                        tracker = new CriteriaMatchTracker(ConsumerImpl.this.criterias);
                                        artIdToCriteriaTracker.put(item.getArtifactId().getIdIntValue(), tracker);
                                    }
                                    this.checkForCancelled();
                                    List matches = ConsumerImpl.this.process((HasCancellation)this, item, handler, tracker.remainingCriteriaToMatch);
                                    tracker.addMatches(item, matches);
                                    continue;
                                }
                                isEndOfQueue = true;
                            }
                        }
                        for (Map.Entry e : artIdToCriteriaTracker.entrySet()) {
                            CriteriaMatchTracker tracker = (CriteriaMatchTracker)e.getValue();
                            tracker.finish(handler);
                        }
                    }
                    catch (Exception ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                    }
                }
            };
        }

        private List<MatchLocation> process(HasCancellation cancellation, AttributeData data, LoadDataHandler handler, Set<CriteriaAttributeKeywords> remaining) throws Exception {
            LinkedList locations = Lists.newLinkedList();
            for (CriteriaAttributeKeywords criteria : this.criterias) {
                cancellation.checkForCancelled();
                Collection valuesToMatch = criteria.getValues();
                Collection typesFilter = criteria.getTypes();
                QueryOption[] options = criteria.getOptions();
                List<MatchLocation> matches = QueryFilterFactoryImpl.this.matcher.process(cancellation, data, valuesToMatch, typesFilter, options);
                if (!Conditions.hasValues(matches)) continue;
                remaining.remove(criteria);
                locations.addAll(matches);
            }
            return locations;
        }

        @Override
        public void onLoadEnd() {
            this.dataToProcess.offer(END_OF_QUEUE);
            try {
                try {
                    this.waitForResults();
                }
                catch (Exception ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    this.cancelFutures();
                    this.executorStarted.set(false);
                    if (this.future != null) {
                        this.future = null;
                    }
                }
            }
            finally {
                this.cancelFutures();
                this.executorStarted.set(false);
                if (this.future != null) {
                    this.future = null;
                }
            }
        }

        private void waitForResults() throws Exception {
            if (this.future != null) {
                this.future.get();
            }
        }

        private void cancelFutures() {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }

    private static class CriteriaMatchTracker {
        private final Map<AttributeData, Set<MatchLocation>> matches = Maps.newHashMap();
        private final Set<CriteriaAttributeKeywords> remainingCriteriaToMatch;

        public CriteriaMatchTracker(List<CriteriaAttributeKeywords> criteria) {
            this.remainingCriteriaToMatch = Sets.newHashSet(criteria);
        }

        public void addMatches(AttributeData attr, Collection<MatchLocation> matches) {
            if (Conditions.hasValues(matches)) {
                HashSet set = this.matches.get(attr);
                if (set == null) {
                    set = Sets.newHashSet();
                    this.matches.put(attr, set);
                }
                set.addAll(matches);
            }
        }

        public void finish(LoadDataHandler handler) {
            if (this.remainingCriteriaToMatch.isEmpty()) {
                for (Map.Entry<AttributeData, Set<MatchLocation>> entry : this.matches.entrySet()) {
                    Set<MatchLocation> locations = entry.getValue();
                    AttributeData attributeData = entry.getKey();
                    for (MatchLocation location : locations) {
                        handler.onData(attributeData, location);
                    }
                }
            }
        }
    }

    private static class ObjectCountingHandler
    extends CountingLoadDataHandler {
        public ObjectCountingHandler(LoadDataHandler handler) {
            super(handler);
        }

        public void onData(ArtifactData data) {
            this.incrementCount();
            super.onData(data);
        }

        public void onDynamicData(Map<String, Object> data) {
            this.incrementCount();
            super.onDynamicData(data);
        }
    }
}

