/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.QueryContext;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.search.QueryCallableFactory;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContextFactory;
import org.eclipse.osee.orcs.db.internal.search.engines.AbstractSearchCallable;

public abstract class AbstractSimpleQueryCallableFactory
implements QueryCallableFactory {
    private final Log logger;
    private final DataLoaderFactory objectLoader;
    private final QuerySqlContextFactory queryContextFactory;

    public AbstractSimpleQueryCallableFactory(Log logger, DataLoaderFactory objectLoader, QuerySqlContextFactory queryEngine) {
        this.logger = logger;
        this.objectLoader = objectLoader;
        this.queryContextFactory = queryEngine;
    }

    @Override
    public QuerySqlContextFactory getSqlContextFactory() {
        return this.queryContextFactory;
    }

    @Override
    public CancellableCallable<Integer> createQuery(final OrcsSession session, final QueryData queryData, final LoadDataHandler handler) {
        return new AbstractSearchCallable(this.logger, session, queryData){

            @Override
            protected Integer innerCall() throws Exception {
                QuerySqlContext queryContext = AbstractSimpleQueryCallableFactory.this.queryContextFactory.createQueryContext(session, queryData, QueryType.SELECT);
                this.checkForCancelled();
                DataLoader loader = AbstractSimpleQueryCallableFactory.this.objectLoader.newDataLoader((QueryContext)queryContext);
                loader.setOptions(queryData.getOptions());
                AtomicInteger counter = new AtomicInteger();
                LoadDataHandler countingHandler = AbstractSimpleQueryCallableFactory.this.createCountingHandler(counter, handler);
                loader.load((HasCancellation)this, countingHandler);
                return counter.get();
            }
        };
    }

    protected abstract LoadDataHandler createCountingHandler(AtomicInteger var1, LoadDataHandler var2);
}

