/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.accessor.UpdatePreviousTxCurrent;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.change.LoadDeltasBetweenBranches;
import org.eclipse.osee.orcs.db.internal.change.MissingChangeItemFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.search.QueryFactory;

public class CommitBranchDatabaseTxCallable
extends AbstractDatastoreTxCallable<TransactionId> {
    private static final String COMMIT_COMMENT = "Commit Branch ";
    private static final String INSERT_COMMIT_TRANSACTION = "insert into osee_tx_details(tx_type, branch_id, transaction_id, osee_comment, time, author, commit_art_id, build_id) values(?,?,?,?,?,?,?,?)";
    private static final String INSERT_COMMIT_ADDRESSING = "insert into osee_txs(transaction_id, branch_id, gamma_id, mod_type, tx_current, app_id) values(?,?,?,?,?,?)";
    private static final String UPDATE_CONFLICT_STATUS = "update osee_conflict SET status = ? WHERE status = ? AND merge_branch_id = ?";
    private static final String UPDATE_MERGE_COMMIT_TX = "update osee_merge set commit_transaction_id = ? Where source_branch_id = ? and dest_branch_id = ?";
    private static final String SELECT_SOURCE_BRANCH_STATE = "select (1) from osee_branch where branch_id=? and branch_state=?";
    private static final String UPDATE_SOURCE_BRANCH_STATE = "update osee_branch set branch_state=? where branch_id=?";
    private final IdentityManager idManager;
    private final ArtifactId committer;
    private final OrcsTokenService tokenService;
    private final Branch sourceBranch;
    private final BranchId destinationBranch;
    private final BranchId mergeBranch;
    private final SqlJoinFactory joinFactory;
    private final TransactionToken sourceTx;
    private final TransactionToken destinationTx;
    private final QueryFactory queryFactory;
    private final MissingChangeItemFactory missingChangeItemFactory;

    public CommitBranchDatabaseTxCallable(IdentityManager idManager, ArtifactId committer, JdbcClient jdbcClient, SqlJoinFactory joinFactory, OrcsTokenService tokenService, Branch sourceBranch, BranchId destinationBranch, TransactionToken sourceTx, TransactionToken destinationTx, BranchId mergeBranch, QueryFactory queryFactory, MissingChangeItemFactory missingChangeItemFactory) {
        super(null, null, jdbcClient);
        this.joinFactory = joinFactory;
        this.idManager = idManager;
        this.committer = committer;
        this.tokenService = tokenService;
        this.sourceBranch = sourceBranch;
        this.destinationBranch = destinationBranch;
        this.sourceTx = sourceTx;
        this.destinationTx = destinationTx;
        this.mergeBranch = mergeBranch;
        this.queryFactory = queryFactory;
        this.missingChangeItemFactory = missingChangeItemFactory;
    }

    @Override
    protected TransactionId handleTxWork(JdbcConnection connection) {
        List changes = new LoadDeltasBetweenBranches(this.getJdbcClient(), this.joinFactory, this.tokenService, (BranchId)this.sourceBranch, this.destinationBranch, this.sourceTx, this.destinationTx, this.mergeBranch, this.queryFactory, this.missingChangeItemFactory).call();
        if ((changes = ChangeItemUtil.computeNetChangesAndFilter(changes)).isEmpty()) {
            throw new OseeStateException("A branch can not be committed without any changes made.", new Object[0]);
        }
        BranchState storedBranchState = this.sourceBranch.getBranchState();
        this.checkPreconditions();
        TransactionId newTx = null;
        try {
            newTx = this.addCommitTransactionToDatabase(this.committer, connection);
            this.updatePreviousCurrentsOnDestinationBranch(connection, changes);
            this.insertCommitAddressing(newTx, connection, changes);
            this.getJdbcClient().runPreparedUpdate(connection, UPDATE_MERGE_COMMIT_TX, new Object[]{newTx, this.sourceBranch, this.destinationBranch});
            this.manageBranchStates();
            if (this.mergeBranch.isValid()) {
                this.getJdbcClient().runPreparedUpdate(UPDATE_CONFLICT_STATUS, new Object[]{ConflictStatus.COMMITTED.getValue(), ConflictStatus.RESOLVED.getValue(), this.mergeBranch});
            }
        }
        catch (OseeCoreException ex) {
            this.updateBranchState(storedBranchState, (BranchId)this.sourceBranch);
            throw ex;
        }
        return newTx;
    }

    public synchronized void checkPreconditions() {
        int count = (Integer)this.getJdbcClient().fetch((Object)0, SELECT_SOURCE_BRANCH_STATE, new Object[]{this.sourceBranch, BranchState.COMMIT_IN_PROGRESS});
        if (this.sourceBranch.getBranchState().isCommitInProgress() || count > 0) {
            throw new OseeStateException("Commit completed or in progress for [%s]", new Object[]{this.sourceBranch});
        }
        if (!this.sourceBranch.getBranchState().equals((Object)BranchState.COMMITTED)) {
            this.updateBranchState(BranchState.COMMIT_IN_PROGRESS, (BranchId)this.sourceBranch);
        }
    }

    private void updateBranchState(BranchState state, BranchId branchId) {
        this.getJdbcClient().runPreparedUpdate(UPDATE_SOURCE_BRANCH_STATE, new Object[]{state, branchId});
    }

    private void updatePreviousCurrentsOnDestinationBranch(JdbcConnection connection, List<ChangeItem> changes) {
        UpdatePreviousTxCurrent updater = new UpdatePreviousTxCurrent(this.getJdbcClient(), connection, this.destinationBranch);
        for (ChangeItem change : changes) {
            ChangeVersion destVersion = change.getDestinationVersion();
            if (!destVersion.isValid()) continue;
            updater.addGamma(destVersion.getGammaId());
        }
        updater.updateTxNotCurrents();
    }

    private TransactionId addCommitTransactionToDatabase(ArtifactId committer, JdbcConnection connection) {
        TransactionId newTransactionNumber = this.idManager.getNextTransactionId();
        Timestamp timestamp = GlobalTime.GreenwichMeanTimestamp();
        String comment = COMMIT_COMMENT + this.sourceBranch.getName();
        this.getJdbcClient().runPreparedUpdate(connection, INSERT_COMMIT_TRANSACTION, new Object[]{TransactionDetailsType.NonBaselined.getId(), this.destinationBranch, newTransactionNumber, comment, timestamp, committer, this.sourceBranch.getAssociatedArtifact(), OseeCodeVersion.getVersionId()});
        return newTransactionNumber;
    }

    private void insertCommitAddressing(TransactionId newTx, JdbcConnection connection, List<ChangeItem> changes) {
        ArrayList<Object[]> insertData = new ArrayList<Object[]>();
        for (ChangeItem change : changes) {
            ModificationType modType = change.getNetChange().getModType();
            ApplicabilityToken appToken = change.getNetChange().getApplicabilityToken();
            insertData.add(new Object[]{newTx, this.destinationBranch, change.getNetChange().getGammaId(), modType, TxCurrent.getCurrent((ModificationType)modType), appToken});
        }
        this.getJdbcClient().runBatchUpdate(connection, INSERT_COMMIT_ADDRESSING, insertData);
    }

    private void manageBranchStates() {
        this.updateBranchState(BranchState.MODIFIED, this.destinationBranch);
        BranchState sourceBranchState = this.sourceBranch.getBranchState();
        if (!(sourceBranchState.isCreationInProgress() || sourceBranchState.isRebaselined() || sourceBranchState.isRebaselineInProgress() || sourceBranchState.isCommitted())) {
            this.updateBranchState(BranchState.COMMITTED, (BranchId)this.sourceBranch);
        }
        if (this.mergeBranch.isValid()) {
            this.updateBranchState(BranchState.COMMITTED, this.mergeBranch);
        }
    }
}

