/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class BlockAttr {
    protected final Pattern typeRegex;
    protected final Pattern contentRegex;
    private Boolean marksComplete;
    protected String data;
    protected final String attrTypeName;
    private final AttributeTypeToken oseeType;

    public BlockAttr(String typeRegex, String contentRegex, String attrTypeName, AttributeTypeToken oseeType) {
        this.typeRegex = Pattern.compile(typeRegex);
        this.contentRegex = Pattern.compile(contentRegex, 32);
        this.attrTypeName = attrTypeName;
        this.oseeType = oseeType;
        this.marksComplete = false;
        this.data = "";
    }

    public Boolean fillContent(String content) {
        Boolean match = false;
        Conditions.assertNotNullOrEmpty((String)content, (String)"null content in add content to block", (Object[])new Object[0]);
        String strippedContent = content.replaceAll("<[^>]+>", "");
        Matcher matcher = this.typeRegex.matcher(strippedContent);
        if (matcher.find()) {
            Matcher contentMatcher = this.contentRegex.matcher(strippedContent);
            this.data = contentMatcher.find() ? contentMatcher.group(1) : "";
            match = true;
        }
        return match;
    }

    public String getImportTypeName() {
        return this.attrTypeName;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public AttributeTypeToken getOseeType() {
        return this.oseeType;
    }

    public Boolean getMarksComplete() {
        return this.marksComplete;
    }

    public void setMarksComplete(Boolean marksComplete) {
        this.marksComplete = marksComplete;
    }

    public String toString() {
        return this.attrTypeName;
    }
}

