/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.operations;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.define.api.importing.ReqNumbering;
import org.eclipse.define.api.importing.RoughArtifact;
import org.eclipse.define.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.importing.resolvers.RoughArtifactTranslatorImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class DoorsTier8RoughToRealOperation {
    private final OrcsApi orcsApi;
    private final RoughArtifactCollector rawData;
    private final ArtifactReadable destinationArtifact;
    private final RoughArtifactTranslatorImpl translator = new RoughArtifactTranslatorImpl();
    private final BranchId branch;
    private final Map<String, ArtifactToken> knownArtsByReqNum = new HashMap<String, ArtifactToken>();
    private final List<ArtifactToken> modifiedParents = new LinkedList<ArtifactToken>();
    private final XResultData results;

    public DoorsTier8RoughToRealOperation(OrcsApi orcsApi, XResultData results, BranchId branch, ArtifactReadable destinationArtifact, RoughArtifactCollector rawData) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.rawData = rawData;
        this.destinationArtifact = destinationArtifact;
        this.results = results;
    }

    public XResultData doWork() {
        this.setupAllKnownArtifacts();
        String operationComment = String.format("Add or Modify %s", this.destinationArtifact.getName());
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (UserId)SystemUser.OseeSystem, operationComment);
        for (RoughArtifact roughArtifact : this.rawData.getRoughArtifacts()) {
            String name = roughArtifact.getName();
            if (name.length() > 32) {
                name = name.substring(0, 32);
            }
            this.resolve(transaction, roughArtifact, this.branch, (ArtifactId)this.destinationArtifact, (ArtifactId)this.destinationArtifact);
            this.results.logf("%s resolved", new Object[]{roughArtifact.getName()});
        }
        transaction.commit();
        this.sortModifiedArtifacts();
        return this.results;
    }

    private void sortModifiedArtifacts() {
        TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (UserId)SystemUser.OseeSystem, "Sort Modified Artifacts");
        for (ArtifactToken parentArtifact : this.modifiedParents) {
            this.sortChildren(parentArtifact, transaction);
        }
        transaction.commit();
    }

    private void sortChildren(ArtifactToken parentArtifact, TransactionBuilder transaction) {
        boolean firstChild = true;
        LinkedList<ArtifactReadable> sortedChildren = new LinkedList<ArtifactReadable>();
        List children = this.orcsApi.getQueryFactory().fromBranch(this.branch).andId((ArtifactId)parentArtifact).getArtifact().getChildren();
        for (ArtifactReadable child : children) {
            ReqNumbering childReqNum = new ReqNumbering(child.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.DoorsHierarchy));
            if (firstChild) {
                sortedChildren.add(child);
                firstChild = false;
                continue;
            }
            boolean added = false;
            int i = sortedChildren.size();
            while (i > 0) {
                ReqNumbering sortedChildReqNum = new ReqNumbering(((ArtifactReadable)sortedChildren.get(i - 1)).getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.DoorsHierarchy));
                if (childReqNum.compareTo(sortedChildReqNum) == 1) {
                    sortedChildren.add(i, child);
                    added = true;
                    break;
                }
                --i;
            }
            if (added) continue;
            sortedChildren.add(0, child);
        }
        transaction.setRelationsAndOrder((ArtifactId)parentArtifact, CoreRelationTypes.DefaultHierarchical_Child, sortedChildren);
    }

    public void resolve(TransactionBuilder transaction, RoughArtifact roughArtifact, BranchId branch, ArtifactId realParentId, ArtifactId rootId) {
        ArtifactToken parentArtifact = this.findParentArtifact(roughArtifact, branch);
        if (parentArtifact != null) {
            ArtifactTypeToken artifactType = roughArtifact.getType();
            if (artifactType.equals(ArtifactTypeToken.SENTINEL)) {
                this.results.logf("Unknown Type error in DoorsTier8RoughToRealOperation Name: %s", new Object[]{roughArtifact.getName()});
            }
            ArtifactToken createdArt = transaction.createArtifact(artifactType, roughArtifact.getName(), roughArtifact.getGuid());
            this.getTranslator().translate(transaction, roughArtifact, (ArtifactId)createdArt);
            transaction.relate((ArtifactId)parentArtifact, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)createdArt, RelationSorter.USER_DEFINED);
            if (!this.modifiedParents.contains(parentArtifact)) {
                this.modifiedParents.add(parentArtifact);
            }
            String fixedHierarchy = roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsHierarchy.getName()).replaceAll("0-", "");
            fixedHierarchy = fixedHierarchy.replaceAll("-", ".");
            this.knownArtsByReqNum.put(fixedHierarchy, createdArt);
        } else {
            this.results.logf("Doors ID resolver cant find parent. roughArtifactifact: [%s]. Doors Hierarchy: [%s]", new Object[]{roughArtifact.getName(), roughArtifact.getAttributes().getSoleAttributeValue("Doors Hierarchy")});
        }
    }

    private ArtifactToken findParentArtifact(RoughArtifact roughArtifact, BranchId branch) {
        String doorsHierarchy = roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsHierarchy.getName());
        doorsHierarchy = doorsHierarchy.replaceAll("0-", "");
        doorsHierarchy = doorsHierarchy.replaceAll("-", ".");
        System.out.println(doorsHierarchy);
        ReqNumbering reqNumber = new ReqNumbering(doorsHierarchy, true);
        ArtifactToken currentParent = this.knownArtsByReqNum.get(reqNumber.getParentString());
        if (currentParent == null) {
            this.results.errorf("Couldn't find parent for %s with number %s", new Object[]{roughArtifact.getRoughAttribute(CoreAttributeTypes.DoorsId.getName()), doorsHierarchy});
        }
        return currentParent;
    }

    private void setupAllKnownArtifacts() {
        List known = this.orcsApi.getQueryFactory().fromBranch(this.branch).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)this.destinationArtifact).asArtifactTokens((AttributeTypeToken)CoreAttributeTypes.DoorsHierarchy);
        known.forEach(item -> {
            ArtifactToken artifactToken = this.knownArtsByReqNum.put(item.getName().replace("-", "."), (ArtifactToken)item);
        });
    }

    private RoughArtifactTranslatorImpl getTranslator() {
        return this.translator;
    }
}

