/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.common.clientserver.dependent.datamodel;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.CommentArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.util.CommonUtil;
import org.eclipse.osee.icteam.common.clientserver.dependent.util.CurrentUserID;

public class TransferableArtifact
extends CurrentUserID
implements ITransferableArtifact {
    private List<CommentArtifact> commentArtifactList = new ArrayList<CommentArtifact>();
    public String name;
    public String parentGuid;
    public String guid;
    public final Map<String, List<String>> attributeMap = new ConcurrentHashMap<String, List<String>>();
    public Map<String, ? extends Object> metaInfo = new HashMap<String, Object>();
    public final Map<String, List<ITransferableArtifact>> relationMap = new ConcurrentHashMap<String, List<ITransferableArtifact>>();
    public String branchGuid;
    public boolean canEdit;
    public String userId;
    public String artifactType;
    public String artifactTypeName;
    public String modifiedDate;
    public String modifiedBy;
    public String revision;
    public Integer[] coloumnsToHide;
    public int localId;
    public boolean isInvalidated = false;
    public boolean includeNonRequirements = true;
    public String urlinfo;

    public List<CommentArtifact> getCommentArtifactList() {
        return this.commentArtifactList;
    }

    public void setCommentArtifactList(List<CommentArtifact> commentArtifactList) {
        this.commentArtifactList = commentArtifactList;
    }

    public Map<String, List<String>> getAttributeMap() {
        return this.attributeMap;
    }

    public boolean isIncludeNonRequirements() {
        return this.includeNonRequirements;
    }

    public void setColoumnsToHide(Integer[] coloumnsToHide) {
        this.coloumnsToHide = coloumnsToHide;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String version) {
        this.revision = version;
    }

    public String getUserId() {
        return this.getUserId(CommonUtil.USER_ID_RETREIVER_FROM_TRANSFERABLE_ARTIFCT);
    }

    public String getUserId(Function<ITransferableArtifact, String> userIdRetreiver) {
        return !Strings.isNullOrEmpty((String)this.userId) ? this.userId : (String)userIdRetreiver.apply((Object)this);
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public String getBranchGuid() {
        return this.branchGuid;
    }

    public void setBranchGuid(Long branchGuid) {
        this.branchGuid = String.valueOf(branchGuid);
    }

    public String getUuid() {
        return this.guid;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public List<String> getAttributes(String key) {
        if (this.attributeMap.containsKey(key)) {
            return this.attributeMap.get(key);
        }
        return null;
    }

    public List<String> getAttributesOrElse(String key, List<String> defaultValue) {
        List<String> attributes = this.getAttributes(key);
        if (attributes != null) {
            return attributes;
        }
        return defaultValue;
    }

    public List<String> getAttributesOrElse(String key) {
        return this.getAttributesOrElse(key, Arrays.asList(""));
    }

    public void putAttributes(String key, List<String> value) {
        this.attributeMap.put(key, value);
    }

    public void putRelations(String key, List<ITransferableArtifact> value) {
        this.relationMap.put(key, value);
    }

    public String[] splitKey(String key) {
        return key.split("##");
    }

    public Map<String, List<ITransferableArtifact>> getRelationMap() {
        HashMap<String, List<ITransferableArtifact>> relations = new HashMap<String, List<ITransferableArtifact>>();
        Set<Map.Entry<String, List<ITransferableArtifact>>> entrySet = this.relationMap.entrySet();
        for (Map.Entry<String, List<ITransferableArtifact>> entry : entrySet) {
            String[] splitKey = this.splitKey(entry.getKey());
            relations.put(splitKey[0], entry.getValue());
        }
        return relations;
    }

    public void setId(Long id) {
        this.guid = String.valueOf(id);
    }

    public Map<String, List<ITransferableArtifact>> getRelationMapWithSides() {
        return this.relationMap;
    }

    public List<ITransferableArtifact> getRelatedArtifacts(String key) {
        Map<String, List<ITransferableArtifact>> relationMap2 = this.getRelationMap();
        if (relationMap2.containsKey(key)) {
            return relationMap2.get(key);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentGuid() {
        return this.parentGuid;
    }

    public void setParentGuid(String parentGuid) {
        this.parentGuid = parentGuid;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributeMap;
    }

    public String getArtifactTypeName() {
        return this.artifactTypeName;
    }

    public void setArtifactTypeName(String artifactTypeName) {
        this.artifactTypeName = artifactTypeName;
    }

    public void setcolumnsToHide(Integer[] colsToHide) {
        this.coloumnsToHide = colsToHide;
    }

    public Integer[] getColoumnsToHide() {
        return this.coloumnsToHide;
    }

    public Map<String, ? extends Object> getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(Map<String, ? extends Object> metaData) {
        this.metaInfo = metaData;
    }

    public String toString() {
        return String.valueOf(this.name) + "-Branch@" + this.branchGuid + "::" + "Guid@" + this.guid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.branchGuid == null ? 0 : this.branchGuid.hashCode());
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransferableArtifact artifact = (TransferableArtifact)obj;
        String _brGId = artifact.getBranchGuid();
        String _gId = artifact.getUuid();
        return _brGId != null && _gId != null && _brGId.equals(this.branchGuid) && _gId.equals(this.guid);
    }

    public void setLocalId(int localId) {
        this.localId = localId;
    }

    public int getLocalId() {
        return this.localId;
    }

    public void removeFromRelated(String key, ITransferableArtifact element) {
        this.getRelatedArtifacts(key).remove(element);
    }

    public boolean isInvalidated() {
        return this.isInvalidated;
    }

    public void setInvalidated(boolean isInvalidated) {
        this.isInvalidated = isInvalidated;
    }

    public String geturlinfo() {
        return this.urlinfo;
    }
}

