/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.IAtsConfigCacheQuery;
import org.eclipse.osee.ats.api.query.IAtsConfigQuery;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.query.IAtsWorkItemFilter;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.query.AbstractAtsQueryService;
import org.eclipse.osee.ats.core.query.AtsConfigCacheQueryImpl;
import org.eclipse.osee.ats.core.query.AtsWorkItemFilter;
import org.eclipse.osee.ats.rest.internal.query.AtsConfigQueryImpl;
import org.eclipse.osee.ats.rest.internal.query.AtsQueryImpl;
import org.eclipse.osee.ats.rest.internal.query.TokenSearchOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class AtsQueryServiceImpl
extends AbstractAtsQueryService {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;
    private final QueryFactory query;

    public AtsQueryServiceImpl(AtsApi atsApi, JdbcService jdbcService, OrcsApi orcsApi) {
        super(jdbcService, atsApi);
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.query = orcsApi.getQueryFactory();
    }

    private QueryBuilder getQuery() {
        return this.query.fromBranch((BranchId)this.atsApi.getAtsBranch());
    }

    public IAtsQuery createQuery(WorkItemType workItemType, WorkItemType ... workItemTypes) {
        AtsQueryImpl query = new AtsQueryImpl(this.atsApi, this.orcsApi);
        query.isOfType(new WorkItemType[]{workItemType});
        WorkItemType[] workItemTypeArray = workItemTypes;
        int n = workItemTypes.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemType type = workItemTypeArray[n2];
            query.isOfType(new WorkItemType[]{type});
            ++n2;
        }
        return query;
    }

    public IAtsConfigQuery createQuery(ArtifactTypeToken ... artifactType) {
        AtsConfigQueryImpl query = new AtsConfigQueryImpl(this.atsApi, this.orcsApi);
        query.isOfType(artifactType);
        return query;
    }

    public IAtsConfigCacheQuery createConfigCacheQuery(ArtifactTypeToken ... artifactType) {
        AtsConfigCacheQueryImpl query = new AtsConfigCacheQueryImpl(this.atsApi);
        query.isOfType(artifactType);
        return query;
    }

    public IAtsWorkItemFilter createFilter(Collection<? extends IAtsWorkItem> workItems) {
        return new AtsWorkItemFilter(workItems, this.atsApi);
    }

    public ArrayList<AtsSearchData> getSavedSearches(AtsUser atsUser, String namespace) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public TransactionId saveSearch(AtsUser atsUser, AtsSearchData data) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public TransactionId removeSearch(AtsUser atsUser, AtsSearchData data) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public AtsSearchData getSearch(AtsUser atsUser, Long id) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public AtsSearchData getSearch(String jsonStr) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public AtsSearchData createSearchData(String namespace, String searchName) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public Collection<ArtifactToken> getArtifacts(Collection<ArtifactId> ids, BranchId branch) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.query.fromBranch(branch).andIds(ids).getResults().getList());
    }

    public Collection<ArtifactToken> getArtifacts(BranchId branch, boolean includeInherited, ArtifactTypeToken ... artifactType) {
        if (includeInherited) {
            return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.query.fromBranch(branch).andIsOfType(artifactType).getResults().getList());
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.query.fromBranch(branch).andTypeEquals(artifactType).getResults().getList());
    }

    public ArtifactToken getArtifactToken(ArtifactId artifactId) {
        return this.getQuery().andId(artifactId).asArtifactToken();
    }

    public Collection<ArtifactToken> getRelatedToTokens(BranchId branch, ArtifactId artifact, RelationTypeSide relationType, ArtifactTypeId artifactType) {
        HashCollection<ArtifactId, ArtifactToken> tokenMap = TokenSearchOperations.getArtifactTokenListFromRelated(branch, Collections.singleton(artifact), artifactType, relationType, this.orcsApi, this.jdbcService);
        Collection result = tokenMap.getValues((Object)artifact);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public <T extends ArtifactId> ArtifactReadable getArtifact(T artifact) {
        ArtifactReadable result = null;
        try {
            IAtsObject atsObject;
            result = artifact instanceof ArtifactReadable ? (ArtifactReadable)artifact : (artifact instanceof IAtsObject ? ((atsObject = (IAtsObject)artifact).getStoreObject() instanceof ArtifactReadable ? (ArtifactReadable)atsObject.getStoreObject() : this.getArtifact(atsObject.getId())) : this.getArtifact(artifact.getId()));
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return result;
    }

    public <T extends IAtsObject> ArtifactReadable getArtifact(T atsObject) {
        ArtifactReadable result = null;
        try {
            if (atsObject.getStoreObject() instanceof ArtifactReadable) {
                result = (ArtifactReadable)atsObject.getStoreObject();
            } else {
                result = this.getArtifact(atsObject.getId());
                if (result != null) {
                    atsObject.setStoreObject((ArtifactToken)result);
                }
            }
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        return result;
    }

    public ArtifactReadable getArtifact(Long id) {
        return (ArtifactReadable)this.getQuery().andUuid(id.longValue()).getResults().getAtMostOneOrNull();
    }

    public ArtifactReadable getArtifact(ArtifactId artifact, BranchId branch) {
        return (ArtifactReadable)this.query.fromBranch(branch).andId(artifact).getArtifactOrNull();
    }

    public ArtifactReadable getArtifact(ArtifactId artifact, BranchId branch, DeletionFlag deletionFlag) {
        return (ArtifactReadable)this.query.fromBranch(branch).andId(artifact).includeDeletedArtifacts().getArtifactOrNull();
    }

    public Collection<ArtifactToken> getArtifacts(Collection<Long> ids) {
        LinkedList<ArtifactToken> artifacts = new LinkedList<ArtifactToken>();
        Iterator iterator = this.getQuery().andUuids(ids).getResults().iterator();
        while (iterator.hasNext()) {
            artifacts.add((ArtifactToken)iterator.next());
        }
        return artifacts;
    }

    public ArtifactToken getArtifactByName(ArtifactTypeToken artifactType, String name) {
        return (ArtifactToken)this.getQuery().andIsOfType(new ArtifactTypeToken[]{artifactType}).andNameEquals(name).getResults().getExactlyOne();
    }

    public ArtifactToken getArtifactByNameOrSentinel(ArtifactTypeToken artifactType, String name) {
        return (ArtifactToken)this.getQuery().andIsOfType(new ArtifactTypeToken[]{artifactType}).andNameEquals(name).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
    }

    public ArtifactToken getHistoricalArtifactOrNull(ArtifactId artifact, TransactionToken transaction, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public ArtifactToken getArtifactByGuid(String guid) {
        return (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch()).andGuid(guid).getResults().getExactlyOne();
    }

    public ArtifactToken getArtifactByGuidOrSentinel(String guid) {
        return (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch()).andGuid(guid).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
    }

    public List<ArtifactToken> getArtifactListFromTypeWithInheritence(ArtifactTypeToken artifactType, BranchId branch, DeletionFlag deletionFlag) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{artifactType}).includeDeletedArtifacts(deletionFlag == DeletionFlag.INCLUDE_DELETED).getResults().getList());
    }

    public List<ArtifactToken> getArtifactListFromTypeAndAttribute(ArtifactTypeId artifactType, AttributeTypeId attributeType, String attributeValue, BranchId branch) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public List<ArtifactToken> getArtifactListFromAttributeValues(AttributeTypeId attributeType, Collection<ArtifactToken> attributeValues, BranchId branch) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public List<ArtifactToken> getArtifactListFromAttributeValues(AttributeTypeId attributeType, Collection<String> attributeValues, BranchId branch, int artifactCountEstimate) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public List<ArtifactToken> getArtifactListFromTypeAndAttribute(ArtifactTypeToken artifactType, AttributeTypeId attributeType, Set<ArtifactToken> ids, BranchId branch) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public Collection<? extends ArtifactToken> getArtifactListFromAttributeKeywords(BranchId branch, String userId, boolean isMatchWordOrder, DeletionFlag deletionFlag, boolean caseSensitive, AttributeTypeString ... attrType) {
        throw new UnsupportedOperationException("Unsupported on the server");
    }

    public Collection<ArtifactToken> getArtifactsById(Collection<ArtifactId> artifactIds, BranchId branch, DeletionFlag deletionFlag) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.orcsApi.getQueryFactory().fromBranch(branch).andIds(artifactIds).includeDeletedArtifacts(deletionFlag == DeletionFlag.INCLUDE_DELETED).getResults().getList());
    }

    public ArtifactToken getArtifactFromAttribute(AttributeTypeString attrType, String value, BranchId branch) {
        List arts = this.orcsApi.getQueryFactory().fromBranch(branch).and((AttributeTypeId)attrType, Arrays.asList(value), QueryOption.EXACT_MATCH_OPTIONS).getResults().getList();
        if (arts.size() == 1) {
            return (ArtifactToken)arts.iterator().next();
        }
        if (arts.size() > 1) {
            throw new OseeArgumentException("Multiple artifacts found with value [%s]", new Object[]{value});
        }
        return ArtifactToken.SENTINEL;
    }

    public List<ArtifactToken> getArtifactListFromAttributeValues(AttributeTypeToken attributeType, Collection<String> values, int estimatedCount) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch()).and((AttributeTypeId)attributeType, values, new QueryOption[0]).getResults().getList());
    }

    public ArtifactToken getArtifactFromTypeAndAttribute(ArtifactTypeToken artifactType, AttributeTypeToken attributeType, String value, BranchId branch) {
        return (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{artifactType}).and((AttributeTypeId)attributeType, Arrays.asList(value), new QueryOption[0]).getResults().getOneOrNull();
    }
}

