/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.InsertionActivityEndpointApi;
import org.eclipse.osee.ats.api.insertion.InsertionEndpointApi;
import org.eclipse.osee.ats.api.insertion.JaxInsertion;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.rest.internal.config.BaseConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionActivityEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class InsertionEndpointImpl
extends BaseConfigEndpointImpl<JaxInsertion>
implements InsertionEndpointApi {
    private final long programId;

    public InsertionEndpointImpl(AtsApi atsApi) {
        this(atsApi, 0L);
    }

    public InsertionEndpointImpl(AtsApi atsApi, long programId) {
        super(AtsArtifactTypes.Insertion, null, atsApi);
        this.programId = programId;
    }

    @PUT
    public Response update(JaxInsertion jaxInsertion) throws Exception {
        ArtifactReadable artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(jaxInsertion.getId());
        if (artifact == null) {
            throw new OseeStateException("Artifact with id %d not found", new Object[]{jaxInsertion.getIdString()});
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactToken insertionArt = changes.createArtifact(this.artifactType, jaxInsertion.getName(), jaxInsertion.getId());
        IAtsInsertion insertion = this.atsApi.getProgramService().getInsertionById((ArtifactId)insertionArt);
        if (!insertionArt.getName().equals(jaxInsertion.getName())) {
            changes.setSoleAttributeValue((IAtsObject)insertion, (AttributeTypeToken)CoreAttributeTypes.Name, (Object)jaxInsertion.getName());
        }
        changes.execute();
        return Response.created((URI)new URI("/" + jaxInsertion.getIdString())).build();
    }

    @Override
    public JaxInsertion getConfigObject(ArtifactId artifact) {
        JaxInsertion jaxInsertion = new JaxInsertion();
        IAtsInsertion insertion = this.atsApi.getProgramService().getInsertionById(artifact);
        jaxInsertion.setName(insertion.getName());
        jaxInsertion.setId(insertion.getId());
        jaxInsertion.setActive(insertion.isActive());
        jaxInsertion.setDescription(insertion.getDescription());
        return jaxInsertion;
    }

    @Override
    public List<JaxInsertion> getObjects() {
        ArrayList<JaxInsertion> insertions = new ArrayList<JaxInsertion>();
        if (this.programId == 0L) {
            for (ArtifactToken art : this.atsApi.getQueryService().getArtifacts(this.artifactType)) {
                insertions.add(this.getConfigObject((ArtifactId)art));
            }
        } else {
            for (ArtifactToken insertionArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)this.atsApi.getQueryService().getArtifact(Long.valueOf(this.programId)), AtsRelationTypes.ProgramToInsertion_Insertion)) {
                JaxInsertion insertion = this.getConfigObject((ArtifactId)insertionArt);
                insertion.setProgramId(this.programId);
                insertions.add(insertion);
            }
        }
        return insertions;
    }

    @Override
    protected void create(JaxInsertion jaxInsertion, ArtifactId insertionArtId, IAtsChangeSet changes) {
        ArtifactReadable insertionArt = (ArtifactReadable)insertionArtId;
        if (insertionArt.getRelatedCount(AtsRelationTypes.ProgramToInsertion_Program) == 0) {
            ArtifactReadable programArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(Long.valueOf(jaxInsertion.getProgramId()));
            changes.relate((Object)programArt, AtsRelationTypes.ProgramToInsertion_Insertion, (Object)insertionArt);
        }
    }

    public InsertionActivityEndpointApi getInsertionActivity(long insertionId) {
        return new InsertionActivityEndpointImpl(this.atsApi, insertionId);
    }
}

